/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal;

import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolvedHandler;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;

public class LocalWorkspaceResolvedConflictHandler
implements ConflictResolvedHandler {
    private final ConflictResolvedHandler parentHandler;
    private final List<GetOperation> allOperations = new ArrayList<GetOperation>();
    private ChangePendedFlags flags = ChangePendedFlags.UNKNOWN;

    public LocalWorkspaceResolvedConflictHandler(ConflictResolvedHandler parentHandler) {
        Check.notNull(parentHandler, "parentHandler");
        this.parentHandler = parentHandler;
    }

    @Override
    public void conflictResolved(Conflict conflict, GetOperation[] getOps, GetOperation[] undoOps, Conflict[] resolvedConflicts, ChangePendedFlags flags) {
        for (GetOperation getOp : getOps) {
            this.allOperations.add(getOp);
        }
        for (GetOperation undoOp : undoOps) {
            this.allOperations.add(undoOp);
        }
        this.flags = this.flags.combine(flags);
        this.parentHandler.conflictResolved(conflict, getOps, undoOps, resolvedConflicts, flags);
    }

    public GetOperation[] getAllOperations() {
        return this.allOperations.toArray(new GetOperation[this.allOperations.size()]);
    }

    public ChangePendedFlags getFlags() {
        return this.flags;
    }
}

