/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.OwnershipState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSetType;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import ms.tfs.versioncontrol.clientservices._03._PendingChange;
import ms.tfs.versioncontrol.clientservices._03._PendingSet;

public final class PendingSet
extends WebServiceObjectWrapper {
    private PendingChange[] pendingChanges;
    private PendingChange[] candidatePendingChanges;

    public PendingSet(_PendingSet pendingSet) {
        super(pendingSet);
        String displayName = pendingSet.getOwnerdisp();
        if (displayName == null || displayName.length() == 0) {
            pendingSet.setOwnerdisp(pendingSet.getOwner());
        }
        if (pendingSet.getPendingChanges() != null) {
            this.pendingChanges = (PendingChange[])WrapperUtils.wrap(PendingChange.class, pendingSet.getPendingChanges());
        }
        if (pendingSet.getSignature() == null) {
            pendingSet.setSignature(GUID.EMPTY.getGUIDString());
        }
    }

    public PendingSet(String name, String ownerName, String ownerDisplayName, OwnershipState ownership, String computer, PendingSetType type, PendingChange[] pendingChanges) {
        this(name, ownerName, ownerDisplayName, ownership, computer, type, pendingChanges, null);
    }

    public PendingSet(String name, String ownerName, String ownerDisplayName, OwnershipState ownership, String computer, PendingSetType type, PendingChange[] pendingChanges, PendingChange[] candidatePendingChanges) {
        this(new _PendingSet(computer, ownerName, ownerDisplayName, ownerName, ownership.getValue(), name, type.getWebServiceObject(), GUID.EMPTY.getGUIDString(), null));
        Check.notNull(pendingChanges, "pendingChanges");
        this.pendingChanges = (PendingChange[])pendingChanges.clone();
        this.candidatePendingChanges = candidatePendingChanges;
    }

    public _PendingSet getWebServiceObject() {
        this.getWebServiceObjectInternal().setPendingChanges((_PendingChange[])WrapperUtils.unwrap(_PendingChange.class, this.pendingChanges));
        return this.getWebServiceObjectInternal();
    }

    private _PendingSet getWebServiceObjectInternal() {
        return (_PendingSet)this.webServiceObject;
    }

    public synchronized String getComputer() {
        return this.getWebServiceObjectInternal().getComputer();
    }

    public synchronized String getName() {
        return this.getWebServiceObjectInternal().getName();
    }

    public synchronized String getOwnerName() {
        return this.getWebServiceObjectInternal().getOwner();
    }

    public synchronized String getOwnerDisplayName() {
        return this.getWebServiceObjectInternal().getOwnerdisp();
    }

    public synchronized PendingSetType getType() {
        return PendingSetType.fromWebServiceObject(this.getWebServiceObjectInternal().getType());
    }

    public synchronized PendingChange[] getPendingChanges() {
        return this.pendingChanges;
    }

    public synchronized GUID getPendingChangeSignature() {
        return new GUID(this.getWebServiceObjectInternal().getSignature());
    }

    public synchronized PendingChange[] getCandidatePendingChanges() {
        return this.candidatePendingChanges;
    }

    public synchronized void setPendingSetDetails() {
        for (PendingChange pc : this.pendingChanges) {
            pc.setPendingSetName(this.getName());
            pc.setPendingSetOwner(this.getOwnerName());
            pc.setPendingSetOwnerDisplay(this.getOwnerDisplayName());
            pc.setInShelveset(this.getType() == PendingSetType.SHELVESET);
        }
        if (this.candidatePendingChanges != null) {
            for (PendingChange pc : this.candidatePendingChanges) {
                pc.setPendingSetName(this.getName());
                pc.setPendingSetOwner(this.getOwnerName());
                pc.setPendingSetOwnerDisplay(this.getOwnerDisplayName());
                pc.setInShelveset(this.getType() == PendingSetType.SHELVESET);
            }
        }
    }
}

