/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.specs;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelSpecParseException;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DeletionVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpecParseException;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;

public final class VersionedFileSpec {
    private static final char ITEM_AND_VERSION_SEPARATOR = ';';
    private static final char VERSION_RANGE_SEPARATOR = '~';
    private String exactUserString;
    private final String item;
    private final DeletionVersionSpec deletionSpec;
    private final VersionSpec[] versions;

    public VersionedFileSpec(String item, DeletionVersionSpec deletionSpec, VersionSpec[] versions) {
        Check.notNullOrEmpty(item, "item");
        Check.notNull(versions, "versions");
        this.item = item;
        this.deletionSpec = deletionSpec;
        this.versions = versions;
    }

    public static VersionedFileSpec parse(String spec, String user, boolean allowVersionRange) throws VersionSpecParseException, LabelSpecParseException {
        String item;
        if (spec == null || spec.length() == 0) {
            throw new VersionSpecParseException(Messages.getString("VersionedFileSpec.VersionSpecMustNotBeNullOrEmpty"));
        }
        if (user == null || user.length() == 0) {
            throw new VersionSpecParseException(Messages.getString("VersionedFileSpec.UserStringMustNotBeNullOrEmpty"));
        }
        int sepIndex = spec.indexOf(59);
        DeletionVersionSpec deletionSpec = null;
        VersionSpec[] versions = new VersionSpec[]{};
        if (sepIndex == -1) {
            item = ItemPath.smartNativeToTFS(ItemPath.canonicalize(spec));
        } else {
            item = ItemPath.smartNativeToTFS(ItemPath.canonicalize(spec.substring(0, sepIndex)));
            VersionSpec[] parsedVersions = VersionSpec.parseMultipleVersionsFromSpec(spec.substring(sepIndex + 1), user, allowVersionRange);
            ArrayList<VersionSpec> tmpVersions = new ArrayList<VersionSpec>();
            boolean alreadyFoundDeletion = false;
            for (int i = 0; i < parsedVersions.length; ++i) {
                if (parsedVersions[i] instanceof DeletionVersionSpec) {
                    if (alreadyFoundDeletion) {
                        throw new VersionSpecParseException(Messages.getString("VersionedFileSpec.OnlyOneDeletionVersionIsAllowedPerItem"));
                    }
                    deletionSpec = (DeletionVersionSpec)parsedVersions[i];
                    alreadyFoundDeletion = true;
                    continue;
                }
                tmpVersions.add(parsedVersions[i]);
            }
            versions = tmpVersions.toArray(new VersionSpec[tmpVersions.size()]);
            if (deletionSpec != null && versions.length > 2) {
                throw new VersionSpecParseException(Messages.getString("VersionedFileSpec.DeletionVersionMayBeCombinedWithAtMostOneOtherVersionSpec"));
            }
        }
        if (item == null || item.length() == 0) {
            throw new VersionSpecParseException(Messages.getString("VersionedFileSpec.NoItemPathCouldBeFoundInTheVersionSpec"));
        }
        return new VersionedFileSpec(item, deletionSpec, versions);
    }

    public String getItem() {
        return ItemPath.smartTFSToNative(this.item);
    }

    public VersionSpec[] getVersions() {
        return this.versions;
    }

    public DeletionVersionSpec getDeletionVersionSpec() {
        return this.deletionSpec;
    }

    public static final String formatForPath(String repositoryOrLocalPath, VersionSpec spec) {
        return repositoryOrLocalPath + ';' + spec.toString();
    }

    public static final String formatForPath(String repositoryOrLocalPath, VersionSpec specFrom, VersionSpec specTo) {
        return repositoryOrLocalPath + ';' + specFrom.toString() + '~' + specTo.toString();
    }

    public String getExactUserString() {
        return this.exactUserString;
    }

    public static String formatPathWithDeletionIfNecessary(String path, int deletionID) {
        Check.notNull(path, "path");
        if (deletionID == 0) {
            return path;
        }
        return path + ';' + new DeletionVersionSpec(deletionID).toString();
    }
}

