/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache;

import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkItemCheckinInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkItemCheckedInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.CheckinItem;
import com.microsoft.tfs.core.clients.workitem.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class SavedCheckin
implements Cloneable {
    public static final String XML_SAVED_CHECKIN = "SavedCheckin";
    private static final String XML_EXCLUDED_ITEMS = "ExcludedItems";
    private static final String XML_COMMENT = "Comment";
    private static final String XML_POLICY_OVERRIDE_COMMENT = "PolicyOverrideComment";
    private static final String XML_ITEM = "Item";
    private static final String XML_SERVER_ITEM = "serverItem";
    private static final String XML_ITEM_ID = "itemId";
    private static final String XML_WORK_ITEMS_CHECKED_INFO = "WorkItemsCheckedInfo";
    private Map<String, CheckinItem> m_excludedItems;
    private String m_comment;
    private CheckinNote m_checkinNotes;
    private WorkItemCheckedInfo[] m_persistentWorkItemsCheckedInfo;
    private String m_policyOverrideComment;

    public SavedCheckin() {
        this.m_excludedItems = CheckinItem.fromServerPaths(null);
        this.initialize(null, null, null, null, false);
    }

    public SavedCheckin(String comment, PendingChange[] excludedChanges, CheckinNote checkinNotes, WorkItemCheckedInfo[] workItemCheckedInfo, String policyOverrideComment) {
        this.m_excludedItems = CheckinItem.fromPendingChanges(excludedChanges);
        this.initialize(comment, checkinNotes, workItemCheckedInfo, policyOverrideComment, false);
    }

    public SavedCheckin(Collection<String> excludedServerPaths, String comment, CheckinNote checkinNotes, WorkItemCheckedInfo[] workItemCheckedInfo, String policyOverrideComment) {
        this.m_excludedItems = CheckinItem.fromServerPaths(excludedServerPaths);
        this.initialize(comment, checkinNotes, workItemCheckedInfo, policyOverrideComment, false);
    }

    private SavedCheckin(Map<String, CheckinItem> excludedItems, String comment, CheckinNote checkinNotes, WorkItemCheckedInfo[] workItemsCheckedInfo, String policyOverrideComment) {
        this.m_excludedItems = excludedItems;
        this.initialize(comment, checkinNotes, workItemsCheckedInfo, policyOverrideComment, false);
    }

    public SavedCheckin(Shelveset shelveset) {
        this.m_excludedItems = CheckinItem.fromPendingChanges(null);
        this.initialize(shelveset.getComment(), shelveset.getCheckinNote(), shelveset.getBriefWorkItemInfo(), shelveset.getPolicyOverrideComment(), false);
    }

    public Object clone() {
        Map<String, CheckinItem> excludedItems = CheckinItem.fromCheckinItems(this.m_excludedItems);
        CheckinNote checkinNotes = null;
        if (this.m_checkinNotes != null) {
            checkinNotes = new CheckinNote(this.m_checkinNotes.getValues());
        }
        WorkItemCheckedInfo[] workItems = null;
        if (this.m_persistentWorkItemsCheckedInfo != null) {
            workItems = new WorkItemCheckedInfo[this.m_persistentWorkItemsCheckedInfo.length];
            System.arraycopy(this.m_persistentWorkItemsCheckedInfo, 0, workItems, 0, this.m_persistentWorkItemsCheckedInfo.length);
        }
        return new SavedCheckin(excludedItems, this.m_comment, checkinNotes, workItems, this.m_policyOverrideComment);
    }

    private void initialize(String comment, CheckinNote checkinNotes, WorkItemCheckedInfo[] workItemsCheckedInfo, String policyOverrideComment, boolean mergeWorkItems) {
        this.m_comment = comment;
        if (checkinNotes != null) {
            ArrayList<CheckinNoteFieldValue> fieldValueList = new ArrayList<CheckinNoteFieldValue>();
            for (CheckinNoteFieldValue fieldValue : checkinNotes.getValues()) {
                if (fieldValue.getValue() == null || fieldValue.getValue().length() <= 0) continue;
                fieldValueList.add(fieldValue);
            }
            if (fieldValueList.size() > 0) {
                this.m_checkinNotes = new CheckinNote(fieldValueList.toArray(new CheckinNoteFieldValue[fieldValueList.size()]));
            }
        }
        if (mergeWorkItems) {
            this.mergeWorkItems(workItemsCheckedInfo);
        } else {
            this.m_persistentWorkItemsCheckedInfo = workItemsCheckedInfo;
        }
        this.m_policyOverrideComment = policyOverrideComment;
    }

    public boolean isExcluded(String targetServerItem) {
        Check.notNull(targetServerItem, "targetServerItem");
        return this.m_excludedItems.containsKey(targetServerItem);
    }

    public void mergeShelvesetMetadata(Shelveset shelveset, PendingChange[] unshelvedChanges) {
        this.updateCheckinItems(unshelvedChanges, new PendingChange[0]);
        this.initialize(shelveset.getComment(), shelveset.getCheckinNote(), shelveset.getBriefWorkItemInfo(), shelveset.getPolicyOverrideComment(), true);
        if (unshelvedChanges != null) {
            for (PendingChange change : unshelvedChanges) {
                this.m_excludedItems.remove(change.getServerItem());
            }
        }
    }

    public void mergeWorkItems(WorkItemCheckedInfo[] workItems) {
        if (workItems == null || workItems.length == 0) {
            return;
        }
        HashMap<Integer, WorkItemCheckedInfo> combined = new HashMap<Integer, WorkItemCheckedInfo>();
        if (this.m_persistentWorkItemsCheckedInfo != null) {
            for (WorkItemCheckedInfo wiInfo : this.m_persistentWorkItemsCheckedInfo) {
                combined.put(wiInfo.getID(), wiInfo);
            }
        }
        for (WorkItemCheckedInfo wiInfo : workItems) {
            combined.put(wiInfo.getID(), wiInfo);
        }
        this.m_persistentWorkItemsCheckedInfo = combined.values().toArray(new WorkItemCheckedInfo[combined.values().size()]);
    }

    public void updateCheckinItems(PendingChange[] checkedPendingChanges, PendingChange[] uncheckedPendingChanges) {
        if (checkedPendingChanges != null) {
            for (PendingChange checkedPendingChange : checkedPendingChanges) {
                this.m_excludedItems.remove(checkedPendingChange.getServerItem());
            }
        }
        if (uncheckedPendingChanges != null) {
            for (PendingChange uncheckedPendingChange : uncheckedPendingChanges) {
                this.m_excludedItems.put(uncheckedPendingChange.getServerItem(), new CheckinItem(uncheckedPendingChange.getServerItem(), uncheckedPendingChange.getItemID()));
            }
        }
    }

    public static SavedCheckin loadFromXML(Element attemptedCheckinNode) {
        String comment = null;
        String policyOverrideComment = null;
        CheckinNote relnotes = null;
        TreeMap<String, CheckinItem> excludedItems = new TreeMap<String, CheckinItem>(ServerPath.TOP_DOWN_COMPARATOR);
        WorkItemCheckedInfo[] workItemsCheckedInfo = null;
        for (Element child : DOMUtils.getChildElements(attemptedCheckinNode)) {
            if (child.getNodeName().equals("CheckinNotes")) {
                relnotes = CheckinNote.loadFromXML(child);
                continue;
            }
            if (child.getNodeName().equals(XML_COMMENT)) {
                comment = DOMUtils.getText(child).trim().replace("\n", "\r\n");
                continue;
            }
            if (child.getNodeName().equals(XML_POLICY_OVERRIDE_COMMENT)) {
                policyOverrideComment = DOMUtils.getText(child).trim().replace("\n", "\r\n");
                continue;
            }
            if (child.getNodeName().equals(XML_EXCLUDED_ITEMS)) {
                SavedCheckin.loadItemsFromXML(child, excludedItems);
                continue;
            }
            if (!child.getNodeName().equals(XML_WORK_ITEMS_CHECKED_INFO)) continue;
            workItemsCheckedInfo = WorkItemCheckedInfo.loadFromXML(child);
        }
        return new SavedCheckin(excludedItems, comment, relnotes, workItemsCheckedInfo, policyOverrideComment);
    }

    private static void loadItemsFromXML(Element itemsNode, Map<String, CheckinItem> itemMap) {
        Check.notNull(itemsNode, "itemsNode");
        Check.notNull(itemMap, "itemMap");
        for (Element itemNode : DOMUtils.getChildElements(itemsNode, XML_ITEM)) {
            String serverItem = itemNode.getAttributes().getNamedItem(XML_SERVER_ITEM).getNodeValue();
            int itemId = XMLConvert.toInt(itemNode.getAttributes().getNamedItem(XML_ITEM_ID).getNodeValue());
            if (serverItem == null || serverItem.length() <= 0) continue;
            itemMap.put(serverItem, new CheckinItem(serverItem, itemId));
        }
    }

    public void saveAsXML(Element parent) {
        Element attemptedCheckinNode = DOMUtils.appendChild(parent, XML_SAVED_CHECKIN);
        DOMUtils.appendChildWithText(attemptedCheckinNode, XML_COMMENT, this.m_comment != null ? this.m_comment : "");
        DOMUtils.appendChildWithText(attemptedCheckinNode, XML_POLICY_OVERRIDE_COMMENT, this.m_policyOverrideComment != null ? this.m_policyOverrideComment : "");
        if (this.m_checkinNotes != null) {
            this.m_checkinNotes.saveAsXML(attemptedCheckinNode);
        }
        WorkItemCheckedInfo.saveAsXML(attemptedCheckinNode, this.m_persistentWorkItemsCheckedInfo);
        if (this.m_excludedItems.size() > 0) {
            this.saveItemsAsXML(attemptedCheckinNode, XML_EXCLUDED_ITEMS, this.m_excludedItems);
        }
    }

    private void saveItemsAsXML(Element attemptedCheckinNode, String tagName, Map<String, CheckinItem> itemList) {
        Element selectedItems = DOMUtils.appendChild(attemptedCheckinNode, tagName);
        if (itemList.size() < 500) {
            for (CheckinItem ci : itemList.values()) {
                Element serverItemNode = DOMUtils.appendChild(selectedItems, XML_ITEM);
                serverItemNode.setAttribute(XML_SERVER_ITEM, ci.getServerItem());
                serverItemNode.setAttribute(XML_ITEM_ID, XMLConvert.toString(ci.getItemID()));
            }
        }
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public String getPolicyOverrideComment() {
        return this.m_policyOverrideComment;
    }

    public void setPolicyOverrideComment(String policyOverrideComment) {
        this.m_policyOverrideComment = policyOverrideComment;
    }

    public CheckinNote getCheckinNotes() {
        return this.m_checkinNotes;
    }

    public void setCheckinNotes(CheckinNote checkinNotes) {
        this.m_checkinNotes = checkinNotes;
    }

    public WorkItemCheckedInfo[] getWorkItemsCheckedInfo() {
        return this.m_persistentWorkItemsCheckedInfo;
    }

    public WorkItemCheckinInfo[] getWorkItemsCheckinInfo(WorkItemClient workItemClient) {
        Check.notNull(workItemClient, "workItemClient");
        return WorkItemCheckinInfo.fromWorkItemCheckedInfo(workItemClient, this.getWorkItemsCheckedInfo());
    }

    public void setPersistentWorkItemsCheckedInfo(WorkItemCheckedInfo[] persistentWorkItemsCheckedInfo) {
        this.m_persistentWorkItemsCheckedInfo = persistentWorkItemsCheckedInfo;
    }

    public String[] getExcludedServerPaths() {
        return this.m_excludedItems.keySet().toArray(new String[this.m_excludedItems.keySet().size()]);
    }

    public void setExcludedServerPaths(String[] serverPaths) {
        this.m_excludedItems = CheckinItem.fromServerPaths(Arrays.asList(serverPaths));
    }

    public WorkItemCheckedInfo[] getAssociateOrResolveWorkItemsCheckedInfo() {
        ArrayList<WorkItemCheckedInfo> infos = new ArrayList<WorkItemCheckedInfo>();
        if (this.m_persistentWorkItemsCheckedInfo != null) {
            for (WorkItemCheckedInfo info : this.m_persistentWorkItemsCheckedInfo) {
                if (info.getCheckinAction() != CheckinWorkItemAction.RESOLVE && info.getCheckinAction() != CheckinWorkItemAction.ASSOCIATE) continue;
                infos.add(info);
            }
        }
        return infos.toArray(new WorkItemCheckedInfo[infos.size()]);
    }
}

