/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.fields.ValuesCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ValuesCollectionImpl
implements ValuesCollection {
    private final List<String> list = new ArrayList<String>();

    public ValuesCollectionImpl(String[] values, int psType) {
        if (values != null && values.length > 0) {
            this.prepareList(values, psType);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(String value) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equalsIgnoreCase(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(String value) {
        return this.indexOf(value) != -1;
    }

    @Override
    public String[] getValues() {
        return this.list.toArray(new String[this.list.size()]);
    }

    private void prepareList(String[] values, int psType) {
        if (psType <= 224) {
            if (psType <= 48) {
                if (psType != 16) {
                    if (psType != 32) {
                        if (psType != 48) {
                            return;
                        }
                    } else {
                        this.prepareIntList(values);
                        return;
                    }
                }
                this.prepareStringList(values);
                return;
            }
            switch (psType) {
                case 64: 
                case 160: 
                case 208: {
                    this.prepareStringList(values);
                    return;
                }
            }
            if (psType == 224) {
                return;
            }
            return;
        }
        if (psType <= 288) {
            if (psType != 240) {
                if (psType != 272) {
                    if (psType != 288) {
                        return;
                    }
                    this.prepareIntList(values);
                    return;
                }
                this.prepareStringList(values);
                return;
            }
            this.prepareDoubleList(values);
            return;
        }
        if (psType <= 528 ? psType != 320 && psType != 528 : psType != 576 && psType != 784) {
            return;
        }
        this.prepareStringList(values);
    }

    private void prepareIntList(String[] values) {
        int i;
        ArrayList<Integer> intList = new ArrayList<Integer>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (i = 0; i < values.length; ++i) {
            boolean parseSuccess = true;
            try {
                intList.add(Integer.valueOf(values[i]));
            }
            catch (NumberFormatException ex) {
                parseSuccess = false;
            }
            if (parseSuccess) continue;
            stringList.add(values[i]);
        }
        Collections.sort(intList);
        Collections.sort(stringList, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < intList.size(); ++i) {
            Integer integer = (Integer)intList.get(i);
            this.list.add(integer.toString());
        }
        for (i = 0; i < stringList.size(); ++i) {
            this.list.add((String)stringList.get(i));
        }
    }

    private void prepareStringList(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.list.add(values[i]);
        }
        Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
    }

    private void prepareDoubleList(String[] values) {
        int i;
        ArrayList<Double> doubleList = new ArrayList<Double>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (i = 0; i < values.length; ++i) {
            boolean parseSuccess = true;
            try {
                doubleList.add(Double.valueOf(values[i]));
            }
            catch (NumberFormatException ex) {
                parseSuccess = false;
            }
            if (parseSuccess) continue;
            stringList.add(values[i]);
        }
        Collections.sort(doubleList);
        Collections.sort(stringList, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < doubleList.size(); ++i) {
            Double doubleValue = (Double)doubleList.get(i);
            this.list.add(doubleValue.toString());
        }
        for (i = 0; i < stringList.size(); ++i) {
            this.list.add((String)stringList.get(i));
        }
    }
}

