/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.files;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnableToSaveException;
import com.microsoft.tfs.core.clients.workitem.files.Attachment;
import com.microsoft.tfs.core.clients.workitem.files.AttachmentCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.files.AttachmentImpl;
import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponentCollection;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitemconfiguration.WorkItemConfigurationSettingsClient;
import java.text.MessageFormat;
import java.util.Iterator;

public class AttachmentCollectionImpl
extends WITComponentCollection<Attachment>
implements AttachmentCollection {
    public AttachmentCollectionImpl(WorkItemImpl workItem) {
        super(workItem);
    }

    @Override
    public Iterator<Attachment> iterator() {
        return this.getComponentSet().iterator();
    }

    @Override
    public int size() {
        return this.getComponentSet().size();
    }

    @Override
    public boolean add(Attachment attachment) {
        return this.addComponent((AttachmentImpl)attachment);
    }

    @Override
    public void remove(Attachment attachment) {
        this.removeComponent((AttachmentImpl)attachment);
    }

    @Override
    public Attachment getAttachmentByFileID(int fileId) {
        for (Attachment attachment : this.getComponentSet()) {
            AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
            if (attachment.getFileID() != fileId || !attachmentImpl.shouldIncludeAsPartOfPublicCollection()) continue;
            return attachment;
        }
        return null;
    }

    @Override
    public void preSave() throws UnableToSaveException {
        String areaNodeUri;
        this.validateAttachmentSizes();
        ProjectImpl project = this.getWorkItemInternal().getTypeInternal().getProjectInternal();
        int areaId = this.getWorkItem().getFields().getAreaID();
        String projectUri = project.getURI();
        if (areaId == project.getID()) {
            NodeImpl areaRootNode = project.getAreaRootNode();
            areaNodeUri = areaRootNode.getURI();
        } else {
            NodeImpl areaNode = project.getNodeInternal().findNodeDownwards(areaId);
            areaNodeUri = areaNode.getURI();
        }
        for (Attachment attachment : this.getComponentSet()) {
            if (!attachment.isNewlyCreated()) continue;
            AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
            attachmentImpl.upload(areaNodeUri, projectUri);
        }
    }

    private void validateAttachmentSizes() throws UnableToSaveException {
        if (!this.hasNewlyCreatedAttachments()) {
            return;
        }
        try {
            WorkItemConfigurationSettingsClient settingsClient = (WorkItemConfigurationSettingsClient)this.getWorkItemInternal().getConnection().getClient(WorkItemConfigurationSettingsClient.class);
            long maxSize = settingsClient.getMaxAttachmentSize();
            boolean updatedMaxSize = false;
            for (Attachment attachment : this.getComponentSet()) {
                if (!attachment.isNewlyCreated() || attachment.getFileSize() <= maxSize) continue;
                if (!updatedMaxSize) {
                    settingsClient.updateMaxAttachmentSize();
                    updatedMaxSize = true;
                    maxSize = settingsClient.updateMaxAttachmentSize();
                    if (attachment.getFileSize() <= maxSize) continue;
                }
                throw new UnableToSaveException(MessageFormat.format(Messages.getString("AttachmentCollectionImpl.FileAttachmentLargerThanMaximumAttachmentSizeFormat"), attachment.getLocalFile().getAbsolutePath(), maxSize));
            }
        }
        catch (Exception ex) {
            throw new UnableToSaveException(ex);
        }
    }

    public boolean hasNewlyCreatedAttachments() {
        for (Attachment attachment : this.getComponentSet()) {
            if (!attachment.isNewlyCreated()) continue;
            return true;
        }
        return false;
    }
}

