/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.TableIndexInfo;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.TablePrimaryKeys;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLMapper;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLMapperFactory;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.DBStatement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DBRowSetHandler
implements RowSetParseHandler {
    private final DBConnection connection;
    private final SQLMapper sqlMapper;
    private String tableName;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> columnTypes = new ArrayList<String>();
    private int pkIndex;
    private String pkColName;
    private String pkType;
    private int fDeletedIndex;
    private int cacheStampIndex;
    private DBStatement deleteStatement;
    private DBStatement insertStatement;
    private boolean existingTable;
    private int deleteCount;
    private int insertCount;
    private int skipCount;
    private long startTime;
    private long maxCacheStamp;
    private final boolean verbose;

    public DBRowSetHandler(DBConnection connection, boolean verbose) {
        this.connection = connection;
        this.verbose = verbose;
        this.sqlMapper = SQLMapperFactory.getSQLMapper(connection);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void handleBeginParsing() {
        this.deleteCount = 0;
        this.insertCount = 0;
        this.skipCount = 0;
        this.startTime = System.currentTimeMillis();
        this.maxCacheStamp = 0L;
    }

    @Override
    public void handleTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void handleColumn(String name, String type) {
        this.columnNames.add(name);
        this.columnTypes.add(type);
    }

    @Override
    public void handleFinishedColumns() {
        StringBuffer sb;
        this.pkColName = TablePrimaryKeys.getPrimaryKeyColumnForTableName(this.tableName);
        this.pkIndex = this.columnNames.indexOf(this.pkColName);
        this.existingTable = this.connection.getDBSpecificOperations().tableExists(this.tableName);
        if (!this.existingTable) {
            sb = new StringBuffer();
            sb.append("create table " + this.tableName + " (");
            for (int i = 0; i < this.columnNames.size(); ++i) {
                String colName = this.columnNames.get(i);
                String colType = this.columnTypes.get(i);
                sb.append(colName + " " + this.sqlMapper.getSQLColumnTypeFromMetadataColumnType(colType, this.tableName, colName));
                if (i == this.pkIndex) {
                    sb.append(" PRIMARY KEY");
                }
                if (i >= this.columnNames.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            this.connection.createStatement(sb.toString()).executeUpdate();
            TableIndexInfo.IndexDescription[] indexDescriptions = TableIndexInfo.getIndexesForTable(this.tableName);
            for (int i = 0; i < indexDescriptions.length; ++i) {
                String createIndexSql = "create index " + indexDescriptions[i].getIndexName() + " on " + this.tableName + " (" + indexDescriptions[i].getColumnName() + ")";
                this.connection.createStatement(createIndexSql).executeUpdate();
            }
            this.connection.createStatement("insert into WITMaxCount values(?,0)").executeUpdate(this.tableName);
        }
        this.fDeletedIndex = this.columnNames.indexOf("fDeleted");
        this.cacheStampIndex = this.columnNames.indexOf("Cachestamp");
        if (this.cacheStampIndex == -1) {
            this.cacheStampIndex = this.columnNames.indexOf("CacheStamp");
        }
        if (this.pkIndex == -1) {
            if (this.columnNames.size() == 1 && this.columnNames.get(0).equals("Column0")) {
                return;
            }
            throw new RuntimeException(MessageFormat.format("primary key column [{0}] not found in table [{1}], columns are: {2}", this.pkColName, this.tableName, this.columnNames));
        }
        this.pkType = this.columnTypes.get(this.pkIndex);
        sb = new StringBuffer("insert into " + this.tableName + " values (");
        for (int i = 0; i < this.columnNames.size(); ++i) {
            sb.append("?");
            if (i >= this.columnNames.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        this.deleteStatement = this.connection.createStatement("delete from " + this.tableName + " where " + this.pkColName + " = ?");
        this.insertStatement = this.connection.createStatement(sb.toString());
        this.deleteStatement.beginBatch();
        this.insertStatement.beginBatch();
    }

    @Override
    public void handleRow(String[] rowValues) {
        String deletedValue;
        if (this.existingTable) {
            Object o = this.sqlMapper.getSQLObject(this.pkType, rowValues[this.pkIndex]);
            this.deleteCount += this.deleteStatement.executeUpdate(o);
        }
        if (this.cacheStampIndex != -1) {
            long cacheStamp = 0L;
            try {
                cacheStamp = Long.parseLong(rowValues[this.cacheStampIndex]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (cacheStamp > this.maxCacheStamp) {
                this.maxCacheStamp = cacheStamp;
            }
        }
        if (this.fDeletedIndex != -1 && (deletedValue = rowValues[this.fDeletedIndex]) != null && deletedValue.trim().equalsIgnoreCase("true")) {
            ++this.skipCount;
            return;
        }
        Object[] params = new Object[rowValues.length];
        for (int i = 0; i < rowValues.length; ++i) {
            params[i] = this.sqlMapper.getSQLObject(this.columnTypes.get(i), rowValues[i]);
        }
        this.insertCount += this.insertStatement.executeUpdate(params);
    }

    @Override
    public void handleEndParsing() {
        if (this.deleteStatement != null) {
            this.deleteStatement.finishBatch();
        }
        if (this.insertStatement != null) {
            this.insertStatement.finishBatch();
        }
        if (this.maxCacheStamp > 0L) {
            String sql = "UPDATE WITMaxCount SET RowVersion = " + this.maxCacheStamp + " WHERE " + "TableName" + " = '" + this.tableName + "'" + " AND   " + "RowVersion" + " < " + this.maxCacheStamp;
            this.connection.createStatement(sql).executeUpdate();
        }
        if (this.verbose) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            System.out.println(MessageFormat.format("table [{0}] deleted {1} inserted {2} skipped {3} cachestamp {4} elapsed {5}", this.tableName, this.deleteCount, this.insertCount, this.skipCount, this.maxCacheStamp, elapsedTime));
        }
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }
}

