/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseException;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.ws.runtime.stax.StaxUtils;
import com.microsoft.tfs.core.ws.runtime.stax.dom.DOMStreamReader;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class RowSetParser {
    private String tableName;
    private int columnCount;

    public RowSetParseHandler parse(Element element, RowSetParseHandler handler) {
        RowSetParseHandler ret;
        DOMStreamReader reader = new DOMStreamReader(element);
        try {
            ret = this.parse(reader, handler);
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new RowSetParseException(MessageFormat.format("Error handling Element with {0} wrapper: {1}", DOMStreamReader.class.getName(), e.toString()));
        }
        return ret;
    }

    public RowSetParseHandler parse(XMLStreamReader reader, RowSetParseHandler handler) {
        String elementName;
        handler.handleBeginParsing();
        if (reader.getEventType() == 7) {
            try {
                while (reader.next() != 1) {
                }
            }
            catch (XMLStreamException e) {
                throw new RowSetParseException("could not find start element in stream for row set");
            }
        }
        if (!"table".equals(elementName = reader.getLocalName())) {
            throw new IllegalArgumentException(MessageFormat.format("the given MessageElement has a name of [{0}], not \"table\"", elementName));
        }
        this.tableName = reader.getAttributeValue(null, "name");
        if (this.tableName == null) {
            throw new RowSetParseException("the metadata table did not have a name");
        }
        handler.handleTableName(this.tableName);
        String localName = null;
        try {
            int event;
            do {
                if ((event = reader.next()) != 1) continue;
                localName = reader.getLocalName();
                if (localName.equals("columns")) {
                    this.parseColumns(reader, handler);
                    handler.handleFinishedColumns();
                    continue;
                }
                if (localName.equals("rows")) {
                    this.parseRows(reader, handler);
                    continue;
                }
                throw new RowSetParseException(MessageFormat.format("Unexpected child element named ''{0}'' inside ''table'' element", localName));
            } while (event != 2);
        }
        catch (XMLStreamException e) {
            throw new RowSetParseException(MessageFormat.format("Error parsing row set XML: {0}", e.toString()));
        }
        handler.handleEndParsing();
        return handler;
    }

    private void parseColumns(XMLStreamReader reader, RowSetParseHandler handler) throws XMLStreamException, RowSetParseException {
        int event;
        this.columnCount = 0;
        String localName = null;
        do {
            if ((event = reader.next()) != 1) continue;
            localName = reader.getLocalName();
            if (localName.equals("c")) {
                this.parseIndividualColumn(reader, handler);
                continue;
            }
            throw new RowSetParseException(MessageFormat.format("Unexpected child element named ''{0}'' inside ''columns'' element", localName));
        } while (event != 2);
    }

    private void parseIndividualColumn(XMLStreamReader reader, RowSetParseHandler handler) throws XMLStreamException, RowSetParseException {
        int event;
        String localName = null;
        String columnName = null;
        String typeName = null;
        do {
            if ((event = reader.next()) != 1) continue;
            localName = reader.getLocalName();
            if (localName.equals("n")) {
                columnName = StaxUtils.getElementTextOrNull(reader);
                continue;
            }
            if (localName.equals("t")) {
                typeName = StaxUtils.getElementTextOrNull(reader);
                continue;
            }
            throw new RowSetParseException(MessageFormat.format("Unexpected child element named ''{0}'' inside ''columns'' element", localName));
        } while (event != 2);
        if (columnName == null) {
            throw new RowSetParseException("Did not get a column name element 'n'");
        }
        if (typeName == null) {
            throw new RowSetParseException("Did not get a column type element 't'");
        }
        handler.handleColumn(columnName, typeName);
        ++this.columnCount;
    }

    private void parseRows(XMLStreamReader reader, RowSetParseHandler handler) throws XMLStreamException, RowSetParseException {
        int event;
        String localName = null;
        do {
            if ((event = reader.next()) != 1) continue;
            localName = reader.getLocalName();
            if (localName.equals("r")) {
                this.parseIndividualRow(reader, handler);
                continue;
            }
            throw new RowSetParseException(MessageFormat.format("Unexpected child element named ''{0}'' inside ''rows'' element", localName));
        } while (event != 2);
    }

    private void parseIndividualRow(XMLStreamReader reader, RowSetParseHandler handler) throws XMLStreamException {
        int event;
        String[] rowValues = new String[this.columnCount];
        int colIx = 0;
        String localName = null;
        do {
            if ((event = reader.next()) != 1) continue;
            localName = reader.getLocalName();
            if (localName.equals("f")) {
                String kAttribute = reader.getAttributeValue(null, "k");
                if (kAttribute != null && kAttribute.length() > 0) {
                    int specifiedColIx = Integer.parseInt(kAttribute);
                    while (colIx < specifiedColIx) {
                        rowValues[colIx++] = null;
                    }
                }
                rowValues[colIx++] = StaxUtils.getElementTextOrNull(reader);
                continue;
            }
            throw new RowSetParseException(MessageFormat.format("Unexpected child element named ''{0}'' inside ''r'' element", localName));
        } while (event != 2);
        handler.handleRow(rowValues);
    }

    public String getTableName() {
        return this.tableName;
    }
}

