/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import java.util.Locale;

public class NodeString
extends NodeItem {
    public NodeString(String value) {
        super(NodeType.STRING, value);
    }

    @Override
    public void appendTo(StringBuffer b) {
        Tools.AppendString(b, this.getValue());
    }

    @Override
    public String getConstStringValue() {
        return this.getValue();
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public boolean canCastTo(DataType dataType, Locale locale) {
        if (dataType == DataType.NUMERIC) {
            if (this.getValue().length() != 0) {
                return Tools.isNumericString(this.getValue());
            }
            return true;
        }
        if (dataType == DataType.DATE) {
            if (this.getValue().length() != 0) {
                return Tools.isDateString(this.getValue(), locale);
            }
            return true;
        }
        if (dataType == DataType.STRING) {
            return true;
        }
        if (dataType == DataType.GUID) {
            return this.getValue().length() == 0 || Tools.IsGUIDString(this.getValue());
        }
        return false;
    }
}

