/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config;

import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.auth.DefaultTransportRequestHandler;
import com.microsoft.tfs.core.config.client.ClientFactory;
import com.microsoft.tfs.core.config.client.DefaultClientFactory;
import com.microsoft.tfs.core.config.httpclient.ConfigurableHTTPClientFactory;
import com.microsoft.tfs.core.config.httpclient.DefaultHTTPClientFactory;
import com.microsoft.tfs.core.config.httpclient.HTTPClientFactory;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.config.serveruri.DefaultServerURIProvider;
import com.microsoft.tfs.core.config.serveruri.ServerURIProvider;
import com.microsoft.tfs.core.config.tfproxy.DefaultTFProxyServerSettingsFactory;
import com.microsoft.tfs.core.config.tfproxy.TFProxyServerSettingsFactory;
import com.microsoft.tfs.core.config.webservice.DefaultWebServiceFactory;
import com.microsoft.tfs.core.config.webservice.WebServiceFactory;
import com.microsoft.tfs.util.Check;
import java.util.Locale;
import java.util.TimeZone;

public class DefaultConnectionAdvisor
implements ConnectionAdvisor {
    private final Locale locale;
    private final TimeZone timeZone;

    public DefaultConnectionAdvisor(Locale locale, TimeZone timeZone) {
        Check.notNull(locale, "locale");
        Check.notNull(timeZone, "timeZone");
        this.locale = locale;
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale(ConnectionInstanceData instanceData) {
        return this.locale;
    }

    @Override
    public TimeZone getTimeZone(ConnectionInstanceData instanceData) {
        return this.timeZone;
    }

    @Override
    public PersistenceStoreProvider getPersistenceStoreProvider(ConnectionInstanceData instanceData) {
        return DefaultPersistenceStoreProvider.INSTANCE;
    }

    @Override
    public ClientFactory getClientFactory(ConnectionInstanceData instanceData) {
        return new DefaultClientFactory();
    }

    @Override
    public HTTPClientFactory getHTTPClientFactory(ConnectionInstanceData instanceData) {
        return new DefaultHTTPClientFactory(instanceData);
    }

    @Override
    public ServerURIProvider getServerURIProvider(ConnectionInstanceData instanceData) {
        return new DefaultServerURIProvider(instanceData);
    }

    @Override
    public TFProxyServerSettingsFactory getTFProxyServerSettingsFactory(ConnectionInstanceData instanceData) {
        return new DefaultTFProxyServerSettingsFactory(instanceData);
    }

    @Override
    public WebServiceFactory getWebServiceFactory(ConnectionInstanceData instanceData) {
        return new DefaultWebServiceFactory(this.getLocale(instanceData), new DefaultTransportRequestHandler(instanceData, (ConfigurableHTTPClientFactory)this.getHTTPClientFactory(instanceData)));
    }
}

