/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.CookieAuthScheme;
import com.microsoft.tfs.core.httpclient.auth.JwtAuthScheme;
import com.microsoft.tfs.core.httpclient.auth.PreemptiveBasicScheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthState {
    public static final Class[] preemptiveAuthSchemes = new Class[]{CookieAuthScheme.class, JwtAuthScheme.class, PreemptiveBasicScheme.class};
    private AuthScheme authScheme = null;
    private boolean authRequested = false;
    private boolean authAttempted = false;
    private boolean preemptive = false;
    private static final Log LOG = LogFactory.getLog(AuthState.class);

    public void invalidate() {
        if (this.authScheme != null) {
            this.authScheme.cleanup();
            this.authScheme = null;
        }
        this.authRequested = false;
        this.authAttempted = false;
        this.preemptive = false;
    }

    public boolean isAuthRequested() {
        return this.authRequested;
    }

    public void setAuthRequested(boolean challengeReceived) {
        this.authRequested = challengeReceived;
    }

    public boolean isAuthAttempted() {
        return this.authAttempted;
    }

    public void setAuthAttempted(boolean challengeResponded) {
        this.authAttempted = challengeResponded;
    }

    public void setPreemptive(Credentials credentials) {
        if (!this.preemptive) {
            if (this.authScheme != null) {
                throw new IllegalStateException("Authentication state already initialized");
            }
            for (int i = 0; i < preemptiveAuthSchemes.length; ++i) {
                try {
                    AuthScheme testScheme = (AuthScheme)preemptiveAuthSchemes[i].newInstance();
                    if (!testScheme.supportsCredentials(credentials)) continue;
                    LOG.debug((Object)("Setting preemptive credentials for " + testScheme.getSchemeName() + " authentication"));
                    this.authScheme = testScheme;
                    this.preemptive = true;
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error initializing authentication scheme: " + preemptiveAuthSchemes[i].getName()), (Throwable)e);
                    throw new IllegalStateException("Authentication scheme implemented by " + preemptiveAuthSchemes[i].getName() + " could not be initialized");
                }
            }
            LOG.info((Object)"No authentication schemes are suitable for preemptive authentication");
        }
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public void setAuthScheme(AuthScheme authScheme) {
        if (authScheme == null) {
            this.invalidate();
            return;
        }
        if (this.preemptive && !this.authScheme.getClass().isInstance(authScheme)) {
            this.preemptive = false;
            this.authAttempted = false;
        }
        if (this.authScheme != null) {
            this.authScheme.cleanup();
        }
        this.authScheme = authScheme;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Auth state: auth requested [");
        buffer.append(this.authRequested);
        buffer.append("]; auth attempted [");
        buffer.append(this.authAttempted);
        if (this.authScheme != null) {
            buffer.append("]; auth scheme [");
            buffer.append(this.authScheme.getSchemeName());
        }
        buffer.append("] preemptive [");
        buffer.append(this.preemptive);
        buffer.append("]");
        return buffer.toString();
    }
}

