/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.methods;

import com.microsoft.tfs.core.httpclient.HttpConnection;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.ProtocolException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog(HeadMethod.class);

    public HeadMethod() {
        this.setFollowRedirects(true);
    }

    public HeadMethod(String uri) {
        super(uri);
        this.setFollowRedirects(true);
    }

    @Override
    public String getName() {
        return "HEAD";
    }

    @Override
    @Deprecated
    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    @Override
    protected void readResponseBody(HttpState state, HttpConnection conn) throws HttpException, IOException {
        LOG.trace((Object)"enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        int bodyCheckTimeout = this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
        if (bodyCheckTimeout < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Check for non-compliant response body. Timeout in " + bodyCheckTimeout + " ms"));
            }
            boolean responseAvailable = false;
            try {
                responseAvailable = conn.isResponseAvailable(bodyCheckTimeout);
            }
            catch (IOException e) {
                LOG.debug((Object)"An IOException occurred while testing if a response was available, we will assume one is not.", (Throwable)e);
                responseAvailable = false;
            }
            if (responseAvailable) {
                if (this.getParams().isParameterTrue("http.protocol.reject-head-body")) {
                    throw new ProtocolException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn((Object)"Body content returned in response to HTTP HEAD");
                super.readResponseBody(state, conn);
            }
        }
    }

    @Deprecated
    public int getBodyCheckTimeout() {
        return this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
    }

    @Deprecated
    public void setBodyCheckTimeout(int timeout) {
        this.getParams().setIntParameter("http.protocol.head-body-timeout", timeout);
    }
}

