/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.util.TFSUsernameParseException;
import com.microsoft.tfs.util.Check;

public final class TFSUser
implements Comparable {
    private final String username;
    private final String domain;

    public TFSUser(String usernameAndOptionalDomain) throws TFSUsernameParseException {
        if (usernameAndOptionalDomain == null) {
            throw new TFSUsernameParseException(Messages.getString("TFSUser.TheUsernameStringIsRequired"));
        }
        int indexOfBackslash = usernameAndOptionalDomain.indexOf(92);
        int indexOfAtSign = usernameAndOptionalDomain.indexOf(64);
        if (indexOfBackslash >= 0 && indexOfAtSign >= 0) {
            throw new TFSUsernameParseException(Messages.getString("TFSUser.UsernameAndDomainMustContainOnlyOneSeparator"));
        }
        if (indexOfBackslash >= 0) {
            this.domain = usernameAndOptionalDomain.substring(0, indexOfBackslash);
            this.username = usernameAndOptionalDomain.substring(indexOfBackslash + 1);
        } else if (indexOfAtSign >= 0) {
            this.username = usernameAndOptionalDomain.substring(0, indexOfAtSign);
            this.domain = usernameAndOptionalDomain.substring(indexOfAtSign + 1);
        } else {
            this.username = usernameAndOptionalDomain;
            this.domain = "";
        }
    }

    public TFSUser(String username, String domain) throws TFSUsernameParseException {
        Check.notNull(username, "username");
        this.username = username;
        this.domain = domain;
    }

    public TFSUser(TFSUser user) {
        this.username = user.username;
        this.domain = user.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TFSUser)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TFSUser other = (TFSUser)obj;
        if (this.domain != null && other.domain != null ? !this.domain.equalsIgnoreCase(other.domain) : this.domain != null ^ other.domain != null) {
            return false;
        }
        return this.username.equalsIgnoreCase(other.username);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.domain == null ? 0 : this.domain.toLowerCase().hashCode());
        result = result * 37 + (this.username == null ? 0 : this.username.toLowerCase().hashCode());
        return result;
    }

    public String toString() {
        if (this.domain != null && this.domain.length() > 0) {
            return this.domain + "\\" + this.username;
        }
        return this.username;
    }

    public int compareTo(Object o) {
        TFSUser other = (TFSUser)o;
        int res = 0;
        if (this.domain != null && other.domain != null) {
            res = this.domain.compareToIgnoreCase(other.domain);
            if (res != 0) {
                return res;
            }
        } else if (this.domain != null ^ other.domain != null) {
            return -1;
        }
        return this.username.compareToIgnoreCase(other.username);
    }
}

