/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodRequestWriter;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity12;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFaultSubCode;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.net.URI;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SOAP12Service
extends SOAPService {
    public SOAP12Service(HttpClient client, URI endpoint, QName port) {
        super(client, endpoint, port);
    }

    public SOAP12Service(URI endpoint, QName port) {
        super(endpoint, port);
    }

    @Override
    protected SOAPRequestEntity buildRequestEntity(String invokedMethodName, SOAPMethodRequestWriter requestWriter) {
        return new SOAPRequestEntity12(invokedMethodName, this.getPort().getNamespaceURI(), requestWriter);
    }

    @Override
    protected String getDefaultSOAPNamespace() {
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    @Override
    protected void examineResponseDOMForFault(Document responseDOM) {
        Node node = this.getChildByName(responseDOM, "soap:Envelope");
        Node faultNode = this.getChildByName(node = this.getChildByName(node, "soap:Body"), "soap:Fault");
        if (faultNode != null) {
            Node textNode;
            Node reasonNode;
            String code = null;
            String subCode = null;
            String message = null;
            String language = null;
            Node codeNode = this.getChildByName(faultNode, "soap:Code");
            if (codeNode != null) {
                code = DOMUtils.getText(this.getChildByName(codeNode, "soap:Value"));
                Node subCodeNode = this.getChildByName(codeNode, "soap:Subcode");
                if (subCodeNode != null) {
                    subCode = DOMUtils.getText(this.getChildByName(subCodeNode, "soap:Value"));
                }
            }
            if ((reasonNode = this.getChildByName(faultNode, "soap:Reason")) != null && (textNode = this.getChildByName(reasonNode, "soap:Text")) != null) {
                message = DOMUtils.getText(textNode);
                language = textNode.getAttributes().getNamedItem("xml:lang").getNodeValue();
            }
            throw new SOAPFault(message, code != null ? new QName(code) : null, null, language, this.getChildByName(faultNode, "detail"), subCode != null ? new SOAPFaultSubCode(new QName(subCode)) : null, null);
        }
    }
}

