/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import java.util.Map;

public class MessageWindow {
    private static Map<Long, MessageWindow> instances;
    private final MessageListener listener;
    private long hwnd = 0L;

    public MessageWindow(long hwndParent, String className, String windowTitle, long userData, MessageListener listener) {
        Check.notNull(className, "className");
        Check.isTrue(className.length() <= 256, "the className must be <= 256 characters");
        Check.notNull(listener, "listener");
        this.listener = listener;
        this.hwnd = MessageWindow.nativeCreateWindow(hwndParent, className, windowTitle, userData);
        instances.put(this.hwnd, this);
    }

    public void destroyWindow() {
        if (this.hwnd != 0L) {
            instances.remove(this.hwnd);
            MessageWindow.nativeDestroyWindow(this.hwnd);
            this.hwnd = 0L;
        }
    }

    public void sendMessage(String className, long[] userData, int msg, long wParam, long lParam) {
        Check.notNullOrEmpty(className, "className");
        Check.isTrue(this.hwnd != 0L, "the message window has been destroyed");
        MessageWindow.nativeSendMessage(this.hwnd, className, userData, msg, wParam, lParam);
    }

    private static void messageReceived(long hwnd, int msg, long wParam, long lParam) {
        MessageWindow instance;
        if (hwnd != 0L && (instance = instances.get(hwnd)) != null) {
            instance.listener.messageReceived(msg, wParam, lParam);
        }
    }

    private static native long nativeCreateWindow(long var0, String var2, String var3, long var4);

    private static native boolean nativeDestroyWindow(long var0);

    private static native void nativeSendMessage(long var0, String var2, long[] var3, int var4, long var5, long var7);

    static {
        NativeLoader.loadLibraryAndLogError("native_messagewindow");
        instances = new HashMap<Long, MessageWindow>();
    }

    public static interface MessageListener {
        public void messageReceived(int var1, long var2, long var4);
    }
}

