/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.encoder.entry;

import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.StreamChunkedEncoder;
import java.io.File;
import java.io.FileInputStream;

public class AppleForkedResourceForkEncoder
extends StreamChunkedEncoder
implements AppleForkedEntryEncoder {
    private final long length;

    public AppleForkedResourceForkEncoder(File dataFile) {
        Check.notNull(dataFile, "dataFile");
        File resourceFile = this.getResourceFile(dataFile);
        long resourceLen = resourceFile.length();
        if (resourceLen > 0L) {
            try {
                FileInputStream resourceStream = new FileInputStream(resourceFile);
                this.setBufferSize(resourceLen);
                this.setStream(resourceStream);
            }
            catch (Exception e) {
                resourceLen = 0L;
            }
        }
        this.length = resourceLen;
    }

    private final File getResourceFile(File dataFile) {
        String filename;
        try {
            filename = dataFile.getCanonicalPath();
        }
        catch (Exception e) {
            filename = dataFile.getAbsolutePath();
        }
        return new File(filename + "/..namedfork/rsrc");
    }

    @Override
    public long getType() {
        return 2L;
    }

    @Override
    public long getLength() {
        return this.length;
    }
}

