/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.Platform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileHelpers {
    private static final String FORCE_HONOR_CASE_SYSPROP = "com.microsoft.tfs.util.FileHelpers.force-honor-case";
    private static final String FORCE_IGNORE_CASE_SYSPROP = "com.microsoft.tfs.util.FileHelpers.force-ignore-case";
    private static final Log log = LogFactory.getLog(FileHelpers.class);
    private static volatile boolean nioClassesLoadable = true;
    private static volatile boolean nioClassesLoaded = false;
    private static Method fileDotMove;
    private static Method pathDotGet;
    private static Object copyOptions;
    private static boolean fileSystemIgnoresCase;
    private static final char[] INVALID_NTFS_PATH_CHARACTERS;
    public static final boolean[] VALID_NTFS_FILE_NAME_CHAR_TABLE;
    private static char[] WILDCARD_CHARACTERS;
    private static final String[] RESERVED_NAMES_LENGTH3;

    public static boolean doesFileSystemIgnoreCase() {
        return fileSystemIgnoresCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentsEqual(File first, File second) throws FileNotFoundException, IOException {
        Check.notNull(first, "first");
        Check.notNull(second, "second");
        if (!first.exists() || !second.exists() || first.length() != second.length()) {
            return false;
        }
        if (first.length() == 0L) {
            return true;
        }
        InputStream firstStream = null;
        InputStream secondStream = null;
        try {
            int firstValue;
            firstStream = new BufferedInputStream(new FileInputStream(first));
            secondStream = new BufferedInputStream(new FileInputStream(second));
            do {
                int secondValue;
                if ((firstValue = firstStream.read()) == (secondValue = secondStream.read())) continue;
                boolean bl = false;
                return bl;
            } while (firstValue != -1);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                firstStream.close();
            }
            catch (Exception e) {}
            try {
                secondStream.close();
            }
            catch (Exception e) {}
        }
    }

    public static boolean isReservedName(String name) {
        String firstThree;
        if (name.length() == 4 && Character.isDigit(name.charAt(3)) && name.charAt(3) != '0' && ((firstThree = name.substring(0, 3)).equalsIgnoreCase("LPT") || firstThree.equalsIgnoreCase("COM"))) {
            return true;
        }
        if (name.length() == 3) {
            for (int i = 0; i < RESERVED_NAMES_LENGTH3.length; ++i) {
                if (!name.equalsIgnoreCase(RESERVED_NAMES_LENGTH3[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidNTFSFileName(String name) {
        return FileHelpers.isValidNTFSFileName(name, false);
    }

    public static boolean isValidNTFSPath(String path) {
        return FileHelpers.isValidNTFSFileName(path, false);
    }

    public static boolean isValidNTFSFileName(String name, boolean permitWildcards) {
        for (int i = 0; i < name.length(); ++i) {
            if (!FileHelpers.isValidNTFSFileNameCharacter(name.charAt(i))) {
                return false;
            }
            if (permitWildcards) continue;
            for (int j = 0; j < WILDCARD_CHARACTERS.length; ++j) {
                if (name.charAt(i) != WILDCARD_CHARACTERS[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidNTFSPath(String path, boolean permitWildcards) {
        for (int i = 0; i < path.length(); ++i) {
            if (!FileHelpers.isValidNTFSPathCharacter(path.charAt(i))) {
                return false;
            }
            if (permitWildcards) continue;
            for (int j = 0; j < WILDCARD_CHARACTERS.length; ++j) {
                if (path.charAt(i) != WILDCARD_CHARACTERS[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidNTFSFileNameCharacter(char c) {
        if (c > '\u007f') {
            return true;
        }
        return VALID_NTFS_FILE_NAME_CHAR_TABLE[c];
    }

    public static boolean isValidNTFSPathCharacter(char c) {
        for (int i = 0; i < INVALID_NTFS_PATH_CHARACTERS.length; ++i) {
            if (c != INVALID_NTFS_PATH_CHARACTERS[i]) continue;
            return false;
        }
        return true;
    }

    public static String removeInvalidNTFSFileNameCharacters(String name) {
        Check.notNull(name, "name");
        StringBuilder sb = new StringBuilder();
        int nameLength = name.length();
        for (int i = 0; i < nameLength; ++i) {
            if (!FileHelpers.isValidNTFSFileNameCharacter(name.charAt(i))) continue;
            sb.append(name.charAt(i));
        }
        return sb.toString();
    }

    public static String removeInvalidNTFSPathCharacters(String path) {
        Check.notNull(path, "name");
        StringBuilder sb = new StringBuilder();
        int nameLength = path.length();
        for (int i = 0; i < nameLength; ++i) {
            if (!FileHelpers.isValidNTFSPathCharacter(path.charAt(i))) continue;
            sb.append(path.charAt(i));
        }
        return sb.toString();
    }

    public static boolean filenameMatches(String filename, String pattern) {
        return FileHelpers.filenameMatches(filename, pattern, FileHelpers.doesFileSystemIgnoreCase());
    }

    public static boolean filenameMatches(String filename, String pattern, boolean ignoreCase) {
        return FileHelpers.filenameMatchesInternal(filename, pattern, ignoreCase) == 1;
    }

    private static int filenameMatchesInternal(String filename, String pattern, boolean ignoreCase) {
        int filenameLength = filename.length();
        int patternLength = pattern.length();
        int f = 0;
        for (int p = 0; p < patternLength; ++p) {
            switch (pattern.charAt(p)) {
                case '\\': {
                    if (++p == patternLength) {
                        return 0;
                    }
                }
                default: {
                    if (!(ignoreCase ? !LocaleInvariantStringHelpers.caseInsensitiveEquals(filename.charAt(f), pattern.charAt(p)) : filename.charAt(f) != pattern.charAt(p))) break;
                    return 0;
                }
                case '?': {
                    break;
                }
                case '*': {
                    while (p < patternLength && pattern.charAt(p) == '*') {
                        ++p;
                    }
                    if (p == patternLength) {
                        return 1;
                    }
                    while (f < filenameLength) {
                        int match;
                        if ((match = FileHelpers.filenameMatchesInternal(filename.substring(f++), pattern.substring(p), ignoreCase)) == 0) continue;
                        return match;
                    }
                    return -1;
                }
            }
            ++f;
        }
        return f == filenameLength ? 1 : 0;
    }

    public static void rename(String source, String target) throws IOException {
        Check.notNull(source, "source");
        Check.notNull(target, "target");
        FileHelpers.rename(new File(source), new File(target));
    }

    public static void rename(File source, File target) throws IOException {
        Check.notNull(source, "source");
        Check.notNull(target, "target");
        if (!source.exists()) {
            throw new FileNotFoundException(MessageFormat.format("Source file {0} does not exist", source));
        }
        File tempFile = null;
        if (target.getParent() != null) {
            FileHelpers.createDirectoryIfNecessary(target.getParent());
        }
        if (target.exists()) {
            tempFile = new File(target.getAbsolutePath() + "-" + System.currentTimeMillis() + ".tmp");
            if (tempFile.exists()) {
                String message = MessageFormat.format("Temp file {0} already exists before rename", tempFile);
                log.warn((Object)message);
                throw new IOException(message);
            }
            if (!FileHelpers.renameInternal(target, tempFile)) {
                String message = MessageFormat.format("Could not rename target {0} to temp file for rename", target);
                log.warn((Object)message);
                throw new IOException(message);
            }
        }
        if (FileHelpers.renameInternal(source, target)) {
            if (tempFile != null && !tempFile.delete()) {
                String message = MessageFormat.format("Error deleting temp file {0} after successful rename, leaving", tempFile);
                log.warn((Object)message);
            }
        } else {
            log.warn((Object)"Main rename failed (source permissions problem?), trying to rename temp file back");
            if (target.exists()) {
                String message = MessageFormat.format("Target {0} exists when it should not, lost race to some other process?", target);
                log.warn((Object)message);
                throw new IOException(message);
            }
            if (tempFile != null && !FileHelpers.renameInternal(tempFile, target)) {
                String message = MessageFormat.format("Error renaming temp file {0} back to target {1} after failed main rename", tempFile, target);
                log.warn((Object)message);
                throw new IOException(message);
            }
            String message = MessageFormat.format(Messages.getString("FileHelpers.FailedToRenameFormat"), source, target);
            log.warn((Object)message);
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean renameInternal(File source, File target) {
        for (int attempt = 1; attempt < 5; ++attempt) {
            if (attempt > 1) {
                int delayMillis = 250;
                log.debug((Object)MessageFormat.format("delaying attempt {0} to rename ''{1}'' to ''{2}'' for {3} milliseconds", attempt, source.getAbsolutePath(), target.getAbsolutePath(), 250));
                try {
                    Thread thread = Thread.currentThread();
                    synchronized (thread) {
                        Thread.currentThread().wait(250L);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)MessageFormat.format("the rename delay was interrupted before attempt {0}", attempt));
                    break;
                }
            }
            if (source.renameTo(target)) {
                return true;
            }
            if (!nioClassesLoadable || !FileHelpers.tryLoadNioClasses()) continue;
            try {
                Object sourcePath = pathDotGet.invoke(null, source.getAbsolutePath(), new String[0]);
                Object targetPath = pathDotGet.invoke(null, target.getAbsolutePath(), new String[0]);
                fileDotMove.invoke(null, sourcePath, targetPath, copyOptions);
                return true;
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        if (!source.isDirectory()) {
            if (IOUtils.copy(source, target)) {
                log.debug((Object)MessageFormat.format("copy ''{1}'' to ''{2}'' succeeded", source.getAbsolutePath(), target.getAbsolutePath()));
                source.delete();
                return true;
            }
            log.debug((Object)MessageFormat.format("copy ''{1}'' to ''{2}'' failed", source.getAbsolutePath(), target.getAbsolutePath()));
        }
        return false;
    }

    public static boolean renameWithoutException(File source, File target) {
        try {
            FileHelpers.rename(source, target);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void deleteFileWithoutException(String path) {
        try {
            new File(path).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean deleteDirectory(String directoryPath) {
        return FileHelpers.deleteDirectory(new File(directoryPath));
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        File[] subdirectories;
        if (!directory.exists() || !directory.isDirectory()) {
            return false;
        }
        for (File subdirectory : subdirectories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            if (FileHelpers.deleteDirectory(subdirectory)) continue;
            return false;
        }
        for (File file : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        })) {
            if (file.delete()) continue;
            return false;
        }
        return directory.delete();
    }

    public static void createDirectoryIfNecessary(String path) throws IOException {
        File directory = new File(path);
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                String message = MessageFormat.format(Messages.getString("FileHelpers.FailedToCreateFormat"), path);
                throw new IOException(message);
            }
        } else if (!directory.isDirectory()) {
            String message = MessageFormat.format(Messages.getString("FileHelpers.FailedToCreateAlreadyExistsFormat"), path);
            throw new IOException(message);
        }
    }

    private static boolean tryLoadNioClasses() {
        if (!nioClassesLoaded) {
            try {
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                Class<?> pathInterface = Class.forName("java.nio.file.Path");
                Class<?> pathsClass = Class.forName("java.nio.file.Paths");
                Class<?> copyOptionInterfaceArray = Class.forName("[Ljava.nio.file.CopyOption;");
                Class<?> copyOptionInterface = Class.forName("java.nio.file.CopyOption");
                fileDotMove = filesClass.getMethod("move", pathInterface, pathInterface, copyOptionInterfaceArray);
                pathDotGet = pathsClass.getMethod("get", String.class, String[].class);
                copyOptions = Array.newInstance(copyOptionInterface, 0);
                nioClassesLoaded = true;
            }
            catch (Exception e) {
                nioClassesLoadable = false;
                log.warn((Object)("Cannot load java.nio.file classes: " + e.getMessage()));
            }
        }
        return nioClassesLoaded;
    }

    static {
        INVALID_NTFS_PATH_CHARACTERS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '<', '>', '|'};
        VALID_NTFS_FILE_NAME_CHAR_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, false, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        WILDCARD_CHARACTERS = new char[]{'?', '*'};
        RESERVED_NAMES_LENGTH3 = new String[]{"CON", "PRN", "AUX", "NUL"};
        fileSystemIgnoresCase = System.getProperty(FORCE_IGNORE_CASE_SYSPROP) != null ? true : (System.getProperty(FORCE_HONOR_CASE_SYSPROP) != null ? false : Platform.isCurrentPlatform(Platform.WINDOWS) || Platform.isCurrentPlatform(Platform.MAC_OS_X));
    }
}

