/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.xml;

import com.microsoft.tfs.util.xml.XMLException;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXPUtils {
    private static final Log log = LogFactory.getLog(JAXPUtils.class);
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        return JAXPUtils.newDocumentBuilderFactory(null);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(ClassLoader contextClassloader) {
        boolean setTCL = contextClassloader != null;
        ClassLoader currentTCL = null;
        if (setTCL) {
            currentTCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassloader);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (log.isTraceEnabled()) {
                String messageFormat = "Created a new DocumentBuilderFactory: {0}(loaded from: {1})";
                String message = MessageFormat.format("Created a new DocumentBuilderFactory: {0}(loaded from: {1})", factory.getClass().getName(), factory.getClass().getClassLoader());
                log.trace((Object)message);
            }
            factory.setNamespaceAware(true);
            DocumentBuilderFactory documentBuilderFactory = factory;
            return documentBuilderFactory;
        }
        catch (FactoryConfigurationError e) {
            throw new XMLException(e);
        }
        finally {
            if (setTCL) {
                Thread.currentThread().setContextClassLoader(currentTCL);
            }
        }
    }

    public static DocumentBuilder newDocumentBuilder() {
        return JAXPUtils.newDocumentBuilder(null);
    }

    public static DocumentBuilder newDocumentBuilder(DocumentBuilderFactory factory) {
        if (factory == null) {
            factory = JAXPUtils.newDocumentBuilderFactory();
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (log.isTraceEnabled()) {
                String messageFormat = "Created a new DocumentBuilder: {0} (loaded from: {1}) (factory: {2})";
                String message = MessageFormat.format("Created a new DocumentBuilder: {0} (loaded from: {1}) (factory: {2})", builder.getClass().getName(), builder.getClass().getClassLoader(), factory.getClass().getName());
                log.trace((Object)message);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e);
        }
    }

    public static TransformerFactory newTransformerFactory() {
        return JAXPUtils.newTransformerFactory(null);
    }

    public static TransformerFactory newTransformerFactory(ClassLoader contextClassloader) {
        boolean setTCL = contextClassloader != null;
        ClassLoader currentTCL = null;
        if (setTCL) {
            currentTCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassloader);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (log.isTraceEnabled()) {
                String messageFormat = "Created a new TransformerFactory: {0} (loaded from: {1})";
                String message = MessageFormat.format("Created a new TransformerFactory: {0} (loaded from: {1})", factory.getClass().getName(), factory.getClass().getClassLoader());
                log.trace((Object)message);
            }
            TransformerFactory transformerFactory = factory;
            return transformerFactory;
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XMLException(e);
        }
        finally {
            if (setTCL) {
                Thread.currentThread().setContextClassLoader(currentTCL);
            }
        }
    }

    public static Transformer newTransformer() {
        return JAXPUtils.newTransformer(null);
    }

    public static Transformer newTransformer(TransformerFactory factory) {
        if (factory == null) {
            factory = JAXPUtils.newTransformerFactory();
        }
        try {
            Transformer transformer = factory.newTransformer();
            if (log.isTraceEnabled()) {
                String messageFormat = "Created a new Transformer: {0} (loaded from: {1}) (factory: {2})";
                String message = MessageFormat.format("Created a new Transformer: {0} (loaded from: {1}) (factory: {2})", transformer.getClass().getName(), transformer.getClass().getClassLoader(), factory.getClass().getName());
                log.trace((Object)message);
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException(e);
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactoryForXSValidation(Object schemaSource) {
        return JAXPUtils.newDocumentBuilderFactoryForXSValidation(null, schemaSource);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactoryForXSValidation(DocumentBuilderFactory factory, Object schemaSource) {
        if (factory == null) {
            factory = JAXPUtils.newDocumentBuilderFactory();
        }
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException e) {
            String messageFormat = "The DocumentBuilderFactory [{0}] loaded from ClassLoader [{1}] does not support JAXP 1.2";
            String message = MessageFormat.format("The DocumentBuilderFactory [{0}] loaded from ClassLoader [{1}] does not support JAXP 1.2", factory.getClass().getName(), factory.getClass().getClassLoader());
            throw new XMLException(message, e);
        }
        if (schemaSource != null) {
            factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaSource);
        }
        return factory;
    }
}

