/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass
public enum ELogLevel {
    ALL(Level.ALL),
    OFF(Level.OFF),
    TRACE(Level.TRACE),
    DEBUG(Level.DEBUG),
    INFO(Level.INFO),
    WARN(Level.WARN),
    ERROR(Level.ERROR),
    FATAL(Level.FATAL);

    private final Level log4Jlevel;
    private static final UnmodifiableMap<Level, ELogLevel> LOG4J_LEVELS;

    private ELogLevel(Level log4Level) {
        this.log4Jlevel = log4Level;
    }

    public Level getLog4JLevel() {
        return this.log4Jlevel;
    }

    public static ELogLevel forLog4jLevel(Level level) {
        return Optional.ofNullable((ELogLevel)((Object)LOG4J_LEVELS.get((Object)level))).orElseThrow(() -> new IllegalArgumentException("Unknown log level: %s".formatted(level)));
    }

    static {
        LOG4J_LEVELS = CollectionUtils.asUnmodifiable(Arrays.stream(ELogLevel.values()).collect(Collectors.toMap(ELogLevel::getLog4JLevel, Function.identity())));
    }
}

