/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;

public enum ContentSyncInfoType {
    NEW_COOKIE(-128),
    REFRESH_DELETE(-95),
    REFRESH_PRESENT(-94),
    SYNC_ID_SET(-93);

    private final byte type;

    private ContentSyncInfoType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    @Nullable
    public static ContentSyncInfoType valueOf(byte type) {
        if (type == NEW_COOKIE.getType()) {
            return NEW_COOKIE;
        }
        if (type == REFRESH_DELETE.getType()) {
            return REFRESH_DELETE;
        }
        if (type == REFRESH_PRESENT.getType()) {
            return REFRESH_PRESENT;
        }
        if (type == SYNC_ID_SET.getType()) {
            return SYNC_ID_SET;
        }
        return null;
    }

    @Nullable
    public static ContentSyncInfoType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "newcookie": 
            case "new-cookie": 
            case "new_cookie": {
                return NEW_COOKIE;
            }
            case "refreshdelete": 
            case "refresh-delete": 
            case "refresh_delete": {
                return REFRESH_DELETE;
            }
            case "refreshpresent": 
            case "refresh-present": 
            case "refresh_present": {
                return REFRESH_PRESENT;
            }
            case "syncidset": 
            case "sync-id-set": 
            case "sync_id_set": {
                return SYNC_ID_SET;
            }
        }
        return null;
    }
}

