import{_ as l,c,ak as n,b as e,x as i,O as a,L as r,o as d}from"./chunks/framework.D4LivsWb.js";const h="/assets/structure_quality_criteria.Dn6xbGTp.png",u="/assets/structure_distribution.DDgV1Rk_.png",p="/assets/redundancy.i_7rtdp5.png",m="/assets/unused_code.Bk2oCXz4.png",g="/assets/lost_stacktrace.B-lK7s0M.png",f="/assets/metrics_view.BdXp0l5G.png",S=JSON.parse('{"title":"How Maintainable is Your Code?","description":"This article explains how to measure and assess the maintainability of your code base using Teamscale. It is based on a solid scientific foundation and our practical experience.","frontmatter":{"title":"How Maintainable is Your Code?","description":"This article explains how to measure and assess the maintainability of your code base using Teamscale. It is based on a solid scientific foundation and our practical experience."},"headers":[],"relativePath":"introduction/understanding-the-maintainability-of-your-code-base/index.md","filePath":"introduction/understanding-the-maintainability-of-your-code-base/index.md"}'),y={name:"introduction/understanding-the-maintainability-of-your-code-base/index.md"},b={class:"tip custom-block"},w={class:"custom-block-title"},v={class:"tip custom-block"},q={class:"custom-block-title"};function k(x,t,T,C,_,I){const s=r("Badge"),o=r("PdfDownload");return d(),c("div",null,[t[6]||(t[6]=n('<h1 id="understanding-the-maintainability-of-your-code-base" tabindex="-1">Understanding the Maintainability of Your Code Base <a class="header-anchor" href="#understanding-the-maintainability-of-your-code-base" aria-label="Permalink to &quot;Understanding the Maintainability of Your Code Base&quot;">​</a></h1><p>The maintainability of your code base plays an important role for the future-proofness of your system. Getting an overview and being able to assess it correctly are important preconditions for steering development and maintenance activities in a meaningful way.</p><h2 id="how-not-to-measure-and-assess-maintainability" tabindex="-1">How (Not) to Measure and Assess Maintainability <a class="header-anchor" href="#how-not-to-measure-and-assess-maintainability" aria-label="Permalink to &quot;How (Not) to Measure and Assess Maintainability&quot;">​</a></h2><p>Maintainability cannot be expressed in terms of a <a href="https://www.cqse.eu/en/news/blog/maintainability-index/" target="_blank" rel="noreferrer">single number</a>, while still retaining valuable and actionable insights <a href="#paper-demystifying-maintainability">[1]</a>. Rather, we suggest to determine maintainability by investigating and assessing different <strong>quality criteria</strong>, such as how the code is <strong>structured</strong> or how much <strong>redundancy</strong> is present in the code base. Differentiating between such quality criteria allows you to get a more thorough, actionable, and objective understanding of the underlying problems and to develop an appropriate and targeted improvement strategy.</p><p>In general, many quality metrics can be calculated on the level of individual files or classes and turned into a weighted average. Often, however, this raw average value is of little use: Are all the problems in a single file or is the problem rather equally distributed? What should be done concretely to improve the situation? We recommend to always examine the distribution of a metric over the entire system. In Teamscale, you can easily get such an overview with assessment charts or treemaps.</p><h3 id="prerequisite-determine-the-correct-scope" tabindex="-1">Prerequisite: Determine the Correct Scope <a class="header-anchor" href="#prerequisite-determine-the-correct-scope" aria-label="Permalink to &quot;Prerequisite: Determine the Correct Scope&quot;">​</a></h3><p>To obtain meaningful results, it is important to set the right measurement scope, especially in a grown code base. In addition to the actual system code, whose maintainability you usually want to assess, a typical code base often contains other source code files, such as code written by a third party or generated code. Since you do not manually maintain those files, you don&#39;t need to assess their maintainability. The system code itself typically comprises application code and test code, which you might want to evaluate differently. For instance, how well exception handling is done might be of less importance in test code than it is in application code. Further, there might be &quot;legacy&quot; areas in the code base that are outside of the focus of current development efforts.</p><p>In order to measure and assess the maintainability of the <strong>relevant areas</strong> of your code base, you have to make sure the <strong>analysis scope</strong> is set accordingly. This includes both <a href="./../../howto/creating-a-project/">setting up your project</a> in a meaningful way for correct measurement, e.g. <a href="./../../howto/creating-a-project/#exclude-generated-third-party-code">excluding generated code</a>, as well as looking at the right portion of the code base, e.g. the application code or a specific folder, when examining and assessing the results.</p><h3 id="measurement-vs-assessment" tabindex="-1">Measurement vs. Assessment <a class="header-anchor" href="#measurement-vs-assessment" aria-label="Permalink to &quot;Measurement vs. Assessment&quot;">​</a></h3><p>It is important to notice that there is a difference between measurement and assessment:</p><ul><li><strong>Measurement</strong> denotes collecting quantitative information about certain properties of a study object.</li><li><strong>Assessment</strong> refers to the evaluation of the measurement results. Assessment requires an interpretation of the measured information.</li></ul><p>Tools like Teamscale measure different aspects of maintainability, such as the length of the methods in the code base. Comparing the measured results with coding standards and commonly accepted best practices allow us to deliver a first interpretation. However, a thorough assessment typically requires a lot of contextual knowledge, such as about the history of the system, the development and maintenance process, the system&#39;s goal, its criticality, its architecture, field problems and so on. This is why assessments should be carefully crafted by <strong>experts</strong> based on the obtained measurement results.</p><h2 id="what-makes-maintainable-code" tabindex="-1">What Makes Maintainable Code? <a class="header-anchor" href="#what-makes-maintainable-code" aria-label="Permalink to &quot;What Makes Maintainable Code?&quot;">​</a></h2><p>A single maintainability problem, such as a single long method or a copied file, does not present a serious issue for a system. But without <a href="./../why-many-fail-to-improve/">effective counter measures</a>, the quality of any system will gradually decay. Especially grown code bases often already contain a large number of quality problems. Chances are you already find yourself far from an &quot;ideal&quot; target.</p><p>As continuous progress is the key to <a href="./../improving-software-quality/#improving-code-quality-using-quality-goals">successfully improving software quality</a>, it is especially important to <a href="./../best-practices/#care-about-trends">observe the trends of relevant quality criteria</a>. However, you also need to be able to understand how far you are off regarding the different indicators to be able to assess the overall situation.</p><p>The quality criteria we apply in practice <a href="#paper-qcs">[2]</a> generally estimate, <strong>how frequently</strong> developers are faced with code that contains specific maintainability problems in their daily work, or—as one customer coined it—the quality of life of the developers. To this end, we measure <strong>how prevalent</strong> a specific problem is in the code base and apply a threshold for its evaluation.</p><p>The following sections explain some of the most important quality criteria for maintainability.</p><h3 id="code-structure" tabindex="-1">Code Structure <a class="header-anchor" href="#code-structure" aria-label="Permalink to &quot;Code Structure&quot;">​</a></h3><p>With &quot;Code structure&quot; we refer to different aspects of how code is organized. Insufficient structure complicates the orientation in the code base and hinders identifying relevant locations when having to modify the code. Moreover, how well the code is structured affects the impact of a change and potentially further required modifications.</p><p>In the following we describe three important quality criteria that assess code structure in more detail: <strong>File Size</strong>, <strong>Method Length</strong> and <strong>Nesting Depth</strong>. They capture how well code is distributed across files, within a file, and within a method.</p><p>In each case, thresholds are used to classify the code into different classes corresponding to <strong>good structure</strong> (<span class="label green" style="padding-top:0px;padding-bottom:0px;">Green</span>), <strong>improvable structure</strong> (<span class="label yellow" style="padding-top:0px;padding-bottom:0px;">Yellow</span>), and <strong>poor structure</strong> (<span class="label red" style="padding-top:0px;padding-bottom:0px;">Red</span>) as shown on the following illustration.</p><p><img src="'+h+'" alt="Code Structure: Quality Criteria" width="1480" height="648" data-zoom="true"></p><div class="tip custom-block"><p class="custom-block-title">Note</p><p>The illustration shows typical thresholds for higher level languages such as Java, C#, or C++. Depending on the language in your code base and your coding guidelines, you might use different thresholds. Teamscale comes with pre-configured thresholds for all <a href="./../../reference/supported-technologies/programming-languages/">supported languages</a>, but you can <a href="./../../howto/editing-an-analysis-profile/">modify</a> these to fit your needs.</p></div><p>In practice, it is very difficult to completely avoid code with improvable or poor structure, especially in grown code bases. There will always be some structural problems, such as a long method to create UI objects or an algorithm with some deep nesting. But these problems are not a threat to maintainability unless they take the upper hand.</p><p>For this reason, rather than judging single problems, we assess how much of the code is affected by structural problems:</p>',25)),e("div",b,[e("p",w,[t[0]||(t[0]=i("Code Structure: Target ",-1)),a(s,{text:"Best Practice"})]),t[1]||(t[1]=e("p",null,[i("Ideally, no more than 5% of the code should be classified as red, and no more than 25% of the code should be classified as red or yellow for each of the code structure quality criteria "),e("a",{href:"#paper-qcs"},"[2]"),i(". In other words, in a healthy code base, at least three quarters of the code should be well structured and at most 5% may be structured poorly, as illustrated with the following distribution charts:")],-1)),t[2]||(t[2]=e("p",null,[e("img",{src:u,alt:"Code Structure: Target",width:"1480",height:"488","data-zoom":"true"})],-1))]),t[7]||(t[7]=n('<p>In the following we elaborate on the three quality criteria for code structure and explain why they are meaningful indicators.</p><h4 id="file-size" tabindex="-1">File Size <a class="header-anchor" href="#file-size" aria-label="Permalink to &quot;File Size&quot;">​</a></h4><p>When looking for the location to perform a code change, the first step is normally to find the right file. The larger this file is, the more effort is required on average for the further search within the file. Overly long files hamper program comprehension and have a negative influence on maintenance.</p><p>Teamscale measures the length of source files in lines of code (LOC) or source lines of code (SLOC), i.e. lines of code without whitespace and comments.</p><h4 id="method-length" tabindex="-1">Method Length <a class="header-anchor" href="#method-length" aria-label="Permalink to &quot;Method Length&quot;">​</a></h4><p>Many programming guidelines recommend to limit the length of a method to a single screen page (typically 20 to 50 lines) <a href="#clean-code">[3]</a>. The reason behind this rule of thumb is that, in order to modify a method, a developer normally has to read and understand the entire method. This is easier if the entire method or at least most of it is visible at the same time on the screen without scrolling. Additionally, long methods require developers to comprehend long statement sequences even if only simple changes are performed. Therefore, long methods make code overall harder to comprehend <a href="#paper-measuring-program-comprehension">[4]</a>.</p><p>Further, long methods often lead to reuse of code fragments through copy-and-paste, thus <a href="https://www.cqse.eu/en/news/blog/the-real-benefits-of-short-methods/" target="_blank" rel="noreferrer">causing multiple additional problems</a>. Beyond that, long methods are also harder to test, which is why it is not surprising that long methods are more error-prone than short methods <a href="#paper-mining-prediction-metrics">[5]</a>.</p><h4 id="nesting-depth" tabindex="-1">Nesting Depth <a class="header-anchor" href="#nesting-depth" aria-label="Permalink to &quot;Nesting Depth&quot;">​</a></h4><p>Most programming languages provide block or nesting mechanisms that allow to control the scope of certain statements. Blocks are used in the bodies of methods and classes, but also in control flow operations such as conditional execution (e.g. <code>if</code>) or loop statements (e.g. <code>for</code>, <code>while</code>).</p><p>The level of nesting affects code understanding, as each nesting level extends the context required to understand the contained code. Therefore, code with little nesting is easier to understand than code with deep nesting <a href="#clean-code">[3]</a>. The general assumption is that two nesting levels of control structures can still be understood with reasonable effort by developers (where counting starts at the method level), while starting with nesting level three, this requires disproportionately more effort.</p><p>Furthermore, deep nesting also makes testing a method more complex as more different branches of the control flow have to be covered.</p><h3 id="redundancy" tabindex="-1">Redundancy <a class="header-anchor" href="#redundancy" aria-label="Permalink to &quot;Redundancy&quot;">​</a></h3><p>Most programming languages provide abstraction mechanisms that allow developers to reuse existing functionality. Nevertheless, copy-and-paste (and possibly modify) is widely utilized to reuse existing code. In practice, this approach often leads to a multitude of source code duplicates—so called &quot;<a href="https://www.cqse.eu/en/news/blog/practical-guide-to-code-clones-part1/" target="_blank" rel="noreferrer"><strong>clones</strong></a>&quot;— which are typically very similar on a syntactic level and hamper the maintenance and evolution of a system in various ways.</p><h4 id="why-redundancy-impedes-maintainability" tabindex="-1">Why Redundancy Impedes Maintainability <a class="header-anchor" href="#why-redundancy-impedes-maintainability" aria-label="Permalink to &quot;Why Redundancy Impedes Maintainability&quot;">​</a></h4><p>Clones unnecessarily increase the amount of code and hence raise the efforts needed for program comprehension and quality assurance activities <a href="#paper-survey-clones">[6, 7]</a>. Any changes, including bug fixes, that affect a clone usually have to be propagated to all of its copies. Localizing and modifying these copies creates significant overhead.</p><p>Besides higher efforts for maintenance and testing, duplicated code is also more error-prone, because copies that are out of sight are easily missed when changing code that has been cloned. Often, developers do not even know that a piece of code has been copied elsewhere. In practice, this can lead to inconsistencies resulting in non-uniform behavior or errors <a href="#paper-do-code-clones-matter">[8]</a>.</p><p>To learn how Teamscale can support you in preventing these inconsistent changes, please refer to our <a href="https://www.cqse.eu/de/news/blog/preventing-inconsistency-bugs/" target="_blank" rel="noreferrer">blog post</a>.</p><h4 id="how-we-measure-redundancy" tabindex="-1">How we Measure Redundancy <a class="header-anchor" href="#how-we-measure-redundancy" aria-label="Permalink to &quot;How we Measure Redundancy&quot;">​</a></h4><p>Teamscale uses <a href="https://www.cqse.eu/en/news/blog/practical-guide-to-code-clones-part2/" target="_blank" rel="noreferrer">clone detection</a> to analyze the redundancy in your system and find duplicated code. To get significant results, by default only clones with at least 10 common consecutive statements are flagged.</p><p><img src="'+p+'" alt="Redundancy: Quality Criteria" width="1480" height="552" data-zoom="true"></p><p>To quantify the overall extent of redundancy, Teamscale calculates the metric <strong><a href="./../../glossary/#clone-coverage">clone coverage</a></strong>, which measures the fraction of statements in a system that is part of at least one copy. Hence, clone coverage can be interpreted as the probability that a randomly selected statement in your code base has at least one copy.</p><p>Similar to structural problems, it is very difficult to completely avoid redundancy, especially in grown code bases. Therefore, rather than assessing single clones, we assess how much of the code is affected by duplication:</p>',22)),e("div",v,[e("p",q,[t[3]||(t[3]=i("Redundancy: Target ",-1)),a(s,{text:"Best Practice"})]),t[4]||(t[4]=e("p",null,[i("Ideally, the clone coverage of your code base should not exceed 5% "),e("a",{href:"#paper-qcs"},"[2]"),i(". Based on our experience, if clone coverage is between 5% and 15%, developers are regularly confronted with clones. As a rule of thumb, a clone coverage value of over 15% indicates that developers have to deal with redundancy on a daily basis.")],-1))]),t[8]||(t[8]=n('<h3 id="other-relevant-criteria" tabindex="-1">Other Relevant Criteria <a class="header-anchor" href="#other-relevant-criteria" aria-label="Permalink to &quot;Other Relevant Criteria&quot;">​</a></h3><p>Code structure and redundancy are two very important quality criteria for assessing the maintainability of your code base. However, for a comprehensive examination of maintainability we recommend to look into the following criteria as well.</p><h4 id="commenting" tabindex="-1">Commenting <a class="header-anchor" href="#commenting" aria-label="Permalink to &quot;Commenting&quot;">​</a></h4><p>In addition to the actual program statements, source code typically also contains comments. Their purpose is to document the system and help fellow developers to understand the code and the rationale behind a specific solution. High quality comments are widely considered to be crucial for program comprehension and thus for the maintainability of a system <a href="#paper-comment-quality">[9]</a>. Nonetheless, in practice, code is often undocumented due to time pressure during development.</p><p>Consequently, two criteria for code comments should be investigated: <strong>Comment Completeness</strong>, i.e. are the relevant portions of the code documented, and <strong>Comment Quality</strong>, i.e. are the existing comments concise, coherent, consistent, and useful? Teamscale provides checks for both criteria.</p><h4 id="naming" tabindex="-1">Naming <a class="header-anchor" href="#naming" aria-label="Permalink to &quot;Naming&quot;">​</a></h4><p>About 70% of source code in software systems consist of identifiers <a href="#paper-naming">[10]</a>. Identifiers provide names for important source code entities, such as classes, enums, interfaces, methods, attributes, parameters, and local variables. Consequently, meaningful, correct identifiers are crucial for reading and understanding your source code <a href="#paper-naming">[10]</a>.</p><p>When investigating identifier names, two aspects should be examined:</p><ol><li>Are the <strong>Naming Conventions</strong> from your coding guidelines being followed consistently throughout the system?</li><li>Is the <strong>Naming Quality</strong> acceptable, i.e. are identifiers easy to read, expressive, and suitable for the domain?</li></ol><p>Teamscale can check naming conventions pretty extensively, while assessing the quality of identifier names usually requires manual inspection.</p><h4 id="code-anomalies" tabindex="-1">Code Anomalies <a class="header-anchor" href="#code-anomalies" aria-label="Permalink to &quot;Code Anomalies&quot;">​</a></h4><p>The term code anomalies broadly refers to violations of commonly accepted best practices. In many cases, such best practices are programming language specific—consider for instance <a href="https://www.python.org/dev/peps/pep-0008/" target="_blank" rel="noreferrer">PEP-8</a> for Python. Nevertheless, they often cover similar best practices regarding maintainability, such as commented out code, unused code, task tags, missing braces, empty blocks, usage of <code>goto</code>, formatting and so on.</p><p>The following Teamscale screenshot shows an unused variable finding, one of the typical code anomalies often found in Java code:</p><p><img src="'+m+'" alt="Unused code" width="1480" height="353" data-zoom="true"></p><p>When investigating the maintainability of your code base, make sure to examine the number of code anomalies per thousand lines of code, i.e. the <strong>Findings Density</strong>. This gives you a measure for how often developers are confronted and hindered by code anomalies. Choose an appropriate threshold based on the number of best practices you are checking.</p><p>In Teamscale, you can use a <a href="./../../glossary/#quality-indicator"><em>Quality Indicator</em></a> when <a href="./../../howto/editing-an-analysis-profile/">configuring the analysis profile</a> to specify which findings should be counted as code anomalies. Make sure to enable calculating <em>Findings Density</em>, when configuring the <em>Quality Indicator</em>.</p><h4 id="exception-handling" tabindex="-1">Exception Handling <a class="header-anchor" href="#exception-handling" aria-label="Permalink to &quot;Exception Handling&quot;">​</a></h4><p>Many programming languages provide exception handling to deal with deviations from the normal program execution. Possible deviations range from programming mistakes, (e.g. dereferencing a <code>NULL</code> pointer), over limitations of the execution environment, which in turn can hint at a programming mistake (e.g. stack overflow, running out of heap memory), to environment limitations out of the program’s control (e.g. write errors due to full disc, timed-out network connections). In addition, exceptions are often used to indicate an erroneous result of a function call, such as parsing errors or invalid user input.</p><p>Improper exception handling can harm the maintainability of your code base in several ways. Consequently, when investigating the maintainability of your code base, you should also analyze if exceptions are handled adequately. Make sure to at least check the following handful of guidelines:</p><ol><li>If <strong>generic exceptions</strong> are thrown generously, it gets difficult to handle deviations selectively, which often leads to more complicated control flow. As a rule of thumb, only the most specific exception possible should be thrown and caught.</li><li>It is good practice to introduce specific <strong>custom exceptions</strong> for your system, if this is doable in your programming language. Custom exceptions represent specific problems and allow to handle domain specific deviations from the normal execution selectively. If possible, custom exceptions should be grouped into a suitable exception hierarchy.</li><li><strong>Empty catch blocks</strong> should be avoided at all costs. Ignored exceptions do not influence the control flow, are not presented to the user, and—most importantly— are not logged. As a consequence, empty catch blocks might actually hide erroneous states.</li><li><strong>Loosing stack traces</strong> vastly complicates finding problems. Hence, the stack trace should always be kept, even when throwing other exceptions. Simply printing the stack trace is usually not enough. At the very least, the stack trace should be logged with the system&#39;s logging mechanism. When throwing from a catch block, the original exception should be wrapped, if possible.</li><li>Instead of <strong>catching <code>NULL</code> pointer exceptions</strong>, developers should check whether a specific object is <code>NULL</code>.</li></ol><p>Teamscale provides checks to analyze exception handling for several programming languages, including Java. The following screenshot shows a finding for a lost stack trace:</p><p><img src="'+g+'" alt="Lost stack trace" width="1480" height="582" data-zoom="true"></p><h2 id="maintainability-overview-in-teamscale" tabindex="-1">Maintainability Overview in Teamscale <a class="header-anchor" href="#maintainability-overview-in-teamscale" aria-label="Permalink to &quot;Maintainability Overview in Teamscale&quot;">​</a></h2><p>The quality criteria described above play a central role in Teamscale. You can access them in various places to get an overview of the maintainability of your code base:</p><ul><li>The <a href="./../../reference/ui/dashboard/"><em>Dashboard</em></a> perspective allows you to configure <a href="./../../reference/ui/dashboard/widgets/">widgets</a> that visualize any of the above-mentioned criteria, including assessment charts and treemaps. You can configure thresholds for the different metrics and observe trends over time.</li><li>The <a href="./../../reference/ui/metrics/"><em>Metrics</em></a> perspective shows an overview of all metrics configured for your project, including the maintainability metrics described above: <img src="'+f+'" alt="Metrics perspective" width="1480" height="638" data-zoom="true"> It allows you to drill down into each metric for every folder in your code base. It also provides a quick way to view a treemap visualizing the distribution of the metric across the files in the code base as well as the history how the metric developed over time.</li></ul><hr><h4 id="further-reading" tabindex="-1">Further Reading: <a class="header-anchor" href="#further-reading" aria-label="Permalink to &quot;Further Reading:&quot;">​</a></h4>',27)),e("ol",null,[e("li",null,[a(o,{id:"paper-demystifying-maintainability",title:"Demystifying Maintainability",subtitle:"M. Broy, F. Deissenboeck, M. Pizka, In: Proceedings of the Workshop on Software Quality (WOSQ’06), 2006",link:"https://www.cqse.eu/publications/2006-demystifying-maintainability.pdf"})]),e("li",null,[a(o,{id:"paper-qcs",title:"Continuous Software Quality Control in Practice",subtitle:"D. Steidl, F. Deissenboeck, M. Poehlmann, R. Heinke, and B. Uhink-Mergenthaler, In: Proceedings of the IEEE International Conference on Software Maintenance and Evolution (ICSME). 2014",link:"https://www.cqse.eu/publications/2014-continuous-software-quality-control-in-practice.pdf"})]),t[5]||(t[5]=e("li",null,[e("span",{id:"clean-code"},[e("strong",null,"Clean Code: A Handbook of Agile Software Craftsmanship")]),e("br"),e("span",{class:"secondary text"}," R. C. Martin, In: Robert C. Martin Series. Prentice Hall, Upper Saddle River, NJ, Aug. 2008")],-1)),e("li",null,[a(o,{id:"paper-measuring-program-comprehension",title:"Measuring program comprehension: A large-scale field study with professionals",subtitle:"X. Xia, L. Bao, D. Lo, Z. Xing, A. E. Hassan, S. Li, In: IEEE Transactions on Software Engineering (TSE). 2017",link:"https://xin-xia.github.io/publication/TSE17.pdf"})]),e("li",null,[a(o,{id:"paper-mining-prediction-metrics",title:"Mining Metrics to Predict Component Failures",subtitle:"N. Nagappan, T. Ball, A. Zeller, In: Proceedings of the 28th International Conference on Software Engineering (ICSE). 2006",link:"https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/tr-2005-149.pdf"})]),e("li",null,[a(o,{id:"paper-survey-clones",title:"Survey of research on software clones",subtitle:"R. Koschke, In: Proceedings of the Dagstuhl Seminar on Duplication, Redundancy, and Similarity in Software. 2007",link:"https://drops.dagstuhl.de/opus/volltexte/2007/962/pdf/06301.KoschkeRainer.962.pdf"})]),e("li",null,[a(o,{id:"paper-survey-clone-detection",title:"A survey on software clone detection research",subtitle:"C. K. Roy, J. R. Cordy, In: Technical report, Queen’s University, Canada. 2007",link:"https://research.cs.queensu.ca/TechReports/Reports/2007-541.pdf"})]),e("li",null,[a(o,{id:"paper-do-code-clones-matter",title:"Do code clones matter?",subtitle:"E. Juergens, F. Deissenboeck, B. Hummel, S. Wagner, In: Proceedings of the 31st International Conference on Software Engineering (ICSE). 2009",link:"https://www.cqse.eu/publications/2009-do-code-clones-matter.pdf"})]),e("li",null,[a(o,{id:"paper-comment-quality",title:"Quality Analysis of Source Code Comments",subtitle:"D. Steidl, B. Hummel, E. Juergens, In: Proceedings of the 21st IEEE Internation Conference on Program Comprehension (ICPC’13). 2013",link:"https://www.cqse.eu/publications/2013-quality-analysis-of-source-code-comments.pdf"})]),e("li",null,[a(o,{id:"paper-naming",title:"Concise and Consistent Naming",subtitle:"F. Deissenboeck, M. Pizka, In: Proceedings of the International Workshop on Program Comprehension (IWPC’05). 2005",link:"https://www.cqse.eu/publications/2005-concise-and-consistent-naming.pdf"})])])])}const M=l(y,[["render",k]]);export{S as __pageData,M as default};
