import{_ as s,c as a,ak as i,o as t}from"./chunks/framework.D4LivsWb.js";const n="/assets/teamscale-create-project.Ch3rpbhK.png",l="/assets/teamscale-on-hold.B6yqa9F8.png",o="/assets/teamscale-start-postponed-rollback.CylSyo15.png",r="/assets/teamscale-activity-coverage.HkPycWXf.png",p="/assets/teamscale-tga-tests-perspective.DjmapYKE.png",h="/assets/teamscale-tga-widget-settings.DvRaqnEN.png",c="/assets/teamscale-tga-widget.Br0Bj0Wl.png",v=JSON.parse('{"title":"Setting up Test Gap Analysis (.NET)","description":"","frontmatter":{"title":"Setting up Test Gap Analysis (.NET)"},"headers":[],"relativePath":"tutorial/setting-up-tga-dotnet/index.md","filePath":"tutorial/setting-up-tga-dotnet/index.md"}'),d={name:"tutorial/setting-up-tga-dotnet/index.md"};function g(k,e,u,m,f,E){return t(),a("div",null,[...e[0]||(e[0]=[i(`<h1 id="setting-up-test-gap-analysis-on-a-net-core-application-blogifier" tabindex="-1">Setting up Test Gap Analysis on a .NET Core Application (Blogifier) <a class="header-anchor" href="#setting-up-test-gap-analysis-on-a-net-core-application-blogifier" aria-label="Permalink to &quot;Setting up Test Gap Analysis on a .NET Core Application (Blogifier)&quot;">​</a></h1><p>As a developer or tester of a .NET application, you may use Teamscale&#39;s <a href="./../../glossary/#test-gap-analysis">Test Gap Analysis (TGA)</a> to improve your testing effectiveness. This tutorial leads you through the setup of TGA on <a href="https://github.com/blogifierdotnet/Blogifier" target="_blank" rel="noreferrer">Blogifier</a>, an open source web application that can be used to self-host a blog.</p><nav class="table-of-contents"><ul><li><a href="#step-1-installing-blogifier">Step 1: Installing Blogifier</a></li><li><a href="#step-2-installing-the-teamscale-net-profiler">Step 2: Installing the Teamscale .NET Profiler</a></li><li><a href="#step-3-uploading-coverage-to-teamscale">Step 3: Uploading Coverage to Teamscale</a><ul><li><a href="#step-3-1-preparing-teamscale">Step 3.1: Preparing Teamscale</a></li><li><a href="#step-3-2-linking-the-version-under-test-to-a-source-code-revision">Step 3.2: Linking the Version Under Test to a Source Code Revision</a></li><li><a href="#step-3-3-uploading-coverage">Step 3.3: Uploading Coverage</a></li></ul></li><li><a href="#step-4-analyzing-coverage-and-test-gaps">Step 4: Analyzing Coverage and Test Gaps</a><ul><li><a href="#step-4-1-test-gaps-at-file-level">Step 4.1: Test Gaps at File Level</a></li><li><a href="#step-4-2-test-gaps-at-method-level">Step 4.2: Test Gaps at Method Level</a></li></ul></li></ul></nav><h2 id="step-1-installing-blogifier" tabindex="-1">Step 1: Installing Blogifier <a class="header-anchor" href="#step-1-installing-blogifier" aria-label="Permalink to &quot;Step 1: Installing Blogifier&quot;">​</a></h2><p>As a prerequisite for running Blogifier, install <a href="https://dotnet.microsoft.com/en-us/download" target="_blank" rel="noreferrer">.NET Core Runtime 6.0 (or newer)</a>.</p><p>Next, download and unzip the <a href="https://github.com/blogifierdotnet/Blogifier/releases/tag/v3.0" target="_blank" rel="noreferrer">3.0 release</a> of Blogifier. Note that the release zip contains not only the executable, but also the corresponding <a href="https://learn.microsoft.com/en-us/visualstudio/debugger/specify-symbol-dot-pdb-and-source-files-in-the-visual-studio-debugger" target="_blank" rel="noreferrer">PDB (symbol) files</a>.</p><p>Finally, start Blogifier.exe and <a href="http://127.0.0.1:5000" target="_blank" rel="noreferrer">open it in your browser</a>, to ensure that the installation was successful.</p><h2 id="step-2-installing-the-teamscale-net-profiler" tabindex="-1">Step 2: Installing the Teamscale .NET Profiler <a class="header-anchor" href="#step-2-installing-the-teamscale-net-profiler" aria-label="Permalink to &quot;Step 2: Installing the Teamscale .NET Profiler&quot;">​</a></h2><p>Download <a href="https://github.com/cqse/teamscale-profiler-dotnet/releases" target="_blank" rel="noreferrer">the latest release of the Teamscale .NET Profiler</a> and unpack it to <code>C:\\teamscale_dotnet_profiler</code>.</p><p>To register the profiler, multiple environment variables have to be set. This can be accomplished either by creating a launch script, or by assigning the environment variables system-wide in the Control Panel. For example you can create the <code>Blogifier.bat</code> batch file next to the <code>Blogifier.exe</code> that sets the necessary environment variables and starts the executable:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>set CORECLR_ENABLE_PROFILING=1</span></span>
<span class="line"><span>set CORECLR_PROFILER={DD0A1BB6-11CE-11DD-8EE8-3F9E55D89593}</span></span>
<span class="line"><span>set CORECLR_PROFILER_PATH_32=C:\\teamscale_dotnet_profiler\\Profiler32.dll</span></span>
<span class="line"><span>set CORECLR_PROFILER_PATH_64=C:\\teamscale_dotnet_profiler\\Profiler64.dll</span></span>
<span class="line"><span>Blogifier.exe</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">Workaround for .NET Core profiling in version &lt;= v23.6.0</p><p>Due to a bug in the older versions of the Teamscale .NET Profiler, it requires the setting of one more environment variable: <code>set COR_PROFILER_PATH=C:\\teamscale_dotnet_profiler\\Profiler64.dll</code></p></div><p>If you want to set the environment variables system-wide, you can do that by navigating to <em>Control Panel</em> &gt; <em>System</em> &gt; <em>Advanced system settings</em> &gt; <em>Environment Variables</em> and adding all the <code>CORECLR_</code> variables.</p><p>Setting the <code>CORECLR_ENABLE_PROFILING</code> variable enables profiling on .NET Core processes. The <code>CORECLR_PROFILER</code> variable provides the GUID of the Teamscale .NET Profiler, which the .NET Runtime uses to verify the profiler DLL on load. Finally, the <code>CORECLR_PROFILER_PATH_32</code> and <code>CORECLR_PROFILER_PATH_64</code> tell the .NET Runtime where to find the profiler binaries.</p><div class="tip custom-block"><p class="custom-block-title">Environment variables depend on the .NET version of the application</p><p>Note that Blogifier is a .NET <strong>Core</strong> application. If you had a .NET <strong>Framework</strong> application, the prefix of the environment variables must be <code>COR_</code> instead of <code>CORECLR_</code>.</p></div><p>Next, we configure the profiler itself. Rename <code>C:\\teamscale_dotnet_profiler\\Profiler.example.yml</code> to <code>C:\\teamscale_dotnet_profiler\\Profiler.yml</code>, then edit the file.</p><p>Adjust the global configuration section, i.e., the first entry below <code>match</code>, as follows:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  # ...</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  match</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # This section matches all processes.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # We configure shared options here but disable the profiler.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # The later match sections will enable the profiler for specific processes.</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      profiler</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        enabled</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        targetdir</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">blogifier_coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        upload_daemon</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      },</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>This globally disables both the profiler, to avoid profiling unnecessary processes, and the automatic upload of coverage, which we will configure later. Moreover, it instructs the profiler to write trace files to <code>C:\\blogifier_coverage</code>.</p><div class="warning custom-block"><p class="custom-block-title">Permissions</p><p>Ensure that <code>C:\\blogifier_coverage</code> exists and that the user running <code>Blogifier.exe</code> can write to it. Otherwise, profiling the process will fail.</p></div><p>Next, add a process-specific configuration section below the global one (delete all other sections from the template), to enable the profiler specifically for the Blogifier executable:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  # ...</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  match</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # This section matches all processes.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # These sections turn on the profiler for specific executables.</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      executableName</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Blogifier.exe&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      profiler</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        enabled</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>To test your setup, start Blogifier with the batch file you have created in Step 2. This will open a console window that shows the logs of the web application, and will start the application on the <a href="http://127.0.0.1:5000" target="_blank" rel="noreferrer">default 5000 port</a>. Open the application in the browser, do something (e.g., create an admin user), and then stop Blogifier by pressing Ctrl+C in the console window. The target directory <code>C:\\blogifier_coverage</code> should now contain a coverage report named like <code>coverage_20230629_1352510131.txt</code> (the date and time parts of the file name will differ) with some content.</p><div class="tip custom-block"><p class="custom-block-title">Reduce Performance Impact</p><p>Profiling processes always incurs a performance impact on the processes. The Teamscale .NET Profiler minimizes this impact, but cannot completely avoid it. To minimize the overall impact, ensure you always <strong>configure the minimal set of processes</strong> (executables).</p></div><div class="tip custom-block"><p class="custom-block-title">Troubleshooting For Missing Coverages</p><p>If you cannot find the coverage files in the target directory, the root cause is typically one of these reasons:</p><ul><li>The profiler was not attached to your application. For this, you can check the log file at <code>C:\\teamscale_dotnet_profiler\\attach.log</code>. The profiler creates this file and always adds a new entry when it is attached. If there is no new entry, check if the profiler is enabled for your executable in the <code>Profiler.yml</code> file.</li><li>The <code>Profiler.yml</code> configuration was not found by the profiler. In this case the profiler creates the coverage files at <code>C:\\Users\\Public</code> by default. To solve the issue, ensure that the <code>Profiler.yml</code> file is in the same folder as the profiler DLLs. You can also provide a custom path to your configuration file via the environment variable <code>COR_PROFILER_CONFIG</code>.</li><li>The <code>Profiler.yml</code> configuration file is syntactically incorrect. In this case in newer versions of the profiler the error is shown and logged to the standard error stream, and the execution of the application is aborted. In older versions, the profiler creates the coverage files at <code>C:\\Users\\Public</code>, and you can find the corresponding error message on the top of the coverage files.</li><li>The target directory does not exist or is not writeable by the user who runs the executable. To solve this, check which user runs the process to be profiled and check the write permissions of the directory.</li></ul></div><h2 id="step-3-uploading-coverage-to-teamscale" tabindex="-1">Step 3: Uploading Coverage to Teamscale <a class="header-anchor" href="#step-3-uploading-coverage-to-teamscale" aria-label="Permalink to &quot;Step 3: Uploading Coverage to Teamscale&quot;">​</a></h2><p>The Teamscale .NET Profiler comes with the ability to upload coverage directly to a Teamscale instance. During the upload, the profiler maps the recorded coverage to the source code of the application under test, using the respective PDB files.</p><div class="tip custom-block"><p class="custom-block-title">Assumption: Reachability of Teamscale</p><p>This guide assumes that the Teamscale server is directly reachable from the test environment via HTTP(S). Alternatively, the profiler can <a href="https://github.com/cqse/teamscale-profiler-dotnet/blob/master/documentation/userguide.md#example-move-to-network-share" target="_blank" rel="noreferrer">upload reports to a file share</a>, where they may be picked up and forwarded from another machine.</p></div><h3 id="step-3-1-preparing-teamscale" tabindex="-1">Step 3.1: Preparing Teamscale <a class="header-anchor" href="#step-3-1-preparing-teamscale" aria-label="Permalink to &quot;Step 3.1: Preparing Teamscale&quot;">​</a></h3><p>In Teamscale, go to <em>Project Configuration</em> and click <em>New project</em>.</p><p>Name the new project <code>blogifier</code> and choose the analysis profile <em>C# Default</em>.</p><p>In the <em>Branching Configuration</em>, change all start dates to <code>2019-09-01</code>.</p><p>Click <em>Source Code Repository</em> and select <em>Git</em>. Create a new account named <code>Blogifier GitHub</code> with the URI <code>https://github.com/blogifierdotnet/Blogifier.git</code> and without credentials. Set the <em>Default branch name</em> to <code>main</code>.</p><p>Click on <em>Advanced Settings</em> and set the <em>End revision (expert option)</em> to <code>2022-02-16</code>. This day is after the <code>v3.0</code> release, so this way Teamscale will analyze all changes between <code>v2.5</code> and <code>v3.0</code>.</p><div class="tip custom-block"><p class="custom-block-title">Start revision and Branching Configuration interact</p><p>If you create a project with more than one source code connector (e.g. to integrate multiple Git repositories into one Teamscale project), you can control how much history is analyzed by Teamscale:</p><ul><li>centrally via the <em>Branching Configuration</em>,</li><li>separately for each connector via the <em>Start Revision</em>.</li></ul><p>If you set both, the more recent of the two dates is applied to the connector.</p></div><div class="tip custom-block"><p class="custom-block-title">Default end revision</p><p>In this example we have set the <em>End revision</em> to shorten the analyzed history. If you want to analyze your code continuously, you have to leave <em>End revision</em> set to the default value. This way Teamscale will always analyze up to the latest revision of the repository.</p></div><p>Click <em>Create project</em>.</p><p><img src="`+n+`" alt="Create project &quot;Blogifier&quot; in Teamscale" width="711" height="1237" data-zoom="true"></p><h3 id="step-3-2-linking-the-version-under-test-to-a-source-code-revision" tabindex="-1">Step 3.2: Linking the Version Under Test to a Source Code Revision <a class="header-anchor" href="#step-3-2-linking-the-version-under-test-to-a-source-code-revision" aria-label="Permalink to &quot;Step 3.2: Linking the Version Under Test to a Source Code Revision&quot;">​</a></h3><p>Create the file <code>C:\\revision.txt</code> and set the file&#39;s content to <code>revision: 8e634ab4b93a60df0e216f3929b35c17cbffb1ca</code>. This revision identifies the source code corresponding to the Blogifier 3.0 release, which we want to link the coverage information to.</p><div class="tip custom-block"><p class="custom-block-title">Keep the Version Under Test and revision.txt in Sync</p><p>If you change the version under test, you also need to adjust the <code>revision.txt</code> accordingly. We recommend to automate this in real test environments.</p></div><div class="tip custom-block"><p class="custom-block-title">Always Using Latest Revision</p><p>If you would like to upload the coverages to the last commit in your repository, you can provide <code>revision: HEAD</code> as a value in the <code>revision.txt</code> file.</p></div><h3 id="step-3-3-uploading-coverage" tabindex="-1">Step 3.3: Uploading Coverage <a class="header-anchor" href="#step-3-3-uploading-coverage" aria-label="Permalink to &quot;Step 3.3: Uploading Coverage&quot;">​</a></h3><p>Edit <code>C:\\teamscale_dotnet_profiler\\Profiler.yml</code> again and change the global configuration section to match the following:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  # ...</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  match</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # This section matches all processes.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # We configure shared options here but disable the profiler.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # The later match sections will enable the profiler for specific processes.</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      profiler</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        enabled</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        targetdir</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">blogifier_coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        upload_daemon</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      },</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      uploader</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        teamscale</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          url</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;http://localhost:8080&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use your URL</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;admin&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use your username</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          accessKey</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;u7a9abc32r45r2uiig3vvv&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use your access key</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;blogifier&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          partition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Manual Tests&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        },</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        pdbDirectory</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">path</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">to</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">Blogifier&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use the folder where Blogifier.pdb is located</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        revisionFile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;C:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">revision.txt&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        assemblyPatterns</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          include</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line highlighted"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">            &quot;Blogifier.*&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">          ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # These sections turn on the profiler for specific executables.</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      executableName</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Blogifier.exe&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      profiler</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        enabled</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>This globally enables and configures automatic uploading of coverage data.</p><p>Use the URL and credentials (username and <a href="./../../glossary/#access-key">access key</a>) of your Teamscale instance. The <code>project</code> option contains the ID of your Teamscale project such that the coverage data is sent to this project. The <code>partition</code> is an arbitrary label that you may use to distinguish coverage source, such as different test stages. Teamscale merges all coverage in the same partition and allows you to inspect coverage in different partitions individually (or in any combination).</p><p>During the upload, the Teamscale .NET Profiler maps the coverage data back to a particular version of the source code, using the PDB files and the revision ID from the <code>revision.txt</code>. It will do so for all the assemblies of Blogifier (whose names match the regular expression <code>Blogifier.*</code>).</p><p>To test your setup, start <code>Blogifier.bat</code>, do something (e.g., create a new blog entry), and stop it again. The profiler automatically schedules uploading of coverage data from terminated processes every five minutes.</p><div class="tip custom-block"><p class="custom-block-title">Project state is &quot;On hold&quot;</p><p>If the uploaded data targets an old commit of the project, Teamscale does not schedule analyzing the data automatically, to prevent large <a href="./../../glossary/#rollback">rollbacks</a>. To proceed, navigate to the Project Configuration &gt; Projects view. When the data is uploaded, the state of the project changes to &quot;On hold&quot;. Click on the &quot;On hold&quot; label, then on the &quot;Start Now&quot; button.</p><p><img src="`+l+'" alt="Project is On Hold after old coverage upload" width="1182" height="242" data-zoom="true"></p><p><img src="'+o+'" alt="Postponed rollback can be started by clicking on the Start Now button" width="1059" height="296" data-zoom="true"></p></div><p>To verify that everything worked as expected, go to the <em>Activity</em> perspective. If you filter your commits for the Commit Type &quot;External Analysis&quot;, and the data was processed successfully, you will see the coverage upload.</p><p><img src="'+r+'" alt="Coverage upload in the project activity" width="1235" height="589" data-zoom="true"></p><div class="warning custom-block"><p class="custom-block-title">Environment variables</p><p>Note that if you did not set the environment variables system-wide, but inside a launch script, ensure that you are starting Blogifier using the launch script (i.e. <code>Blogifier.bat</code>) instead of running <code>Blogifier.exe</code> directly. Otherwise this will result in a wrong configuration of the environment variables.</p></div><div class="warning custom-block"><p class="custom-block-title">Permissions</p><p>Ensure that the user running the executable has read access to the folder containing the PDB files. Otherwise, processing the coverage will fail.</p></div><div class="tip custom-block"><p class="custom-block-title">Upload Interval</p><p>You may configure the upload interval in the <code>Profiler.yml</code> file, using the <code>uploadIntervalInMinutes</code> option.</p></div><div class="tip custom-block"><p class="custom-block-title">Reduce Performance Impact</p><p>Mapping coverage data to source code takes some processing time that adds to your overall test execution time. To avoid wasting time on unnecessary mapping, ensure you always <strong>configure the minimal set of assemblies</strong>, i.e., exactly the assemblies containing the code that you want to identify test gaps in.</p></div><div class="tip custom-block"><p class="custom-block-title">Missing Uploads</p><p>If the Upload Daemon has failed to upload the coverage files, you can find the error logs at <code>C:\\teamscale_dotnet_profiler\\UploadDaemon\\UploadDaemon.log</code>.</p></div><h2 id="step-4-analyzing-coverage-and-test-gaps" tabindex="-1">Step 4: Analyzing Coverage and Test Gaps <a class="header-anchor" href="#step-4-analyzing-coverage-and-test-gaps" aria-label="Permalink to &quot;Step 4: Analyzing Coverage and Test Gaps&quot;">​</a></h2><h3 id="step-4-1-test-gaps-at-file-level" tabindex="-1">Step 4.1: Test Gaps at File Level <a class="header-anchor" href="#step-4-1-test-gaps-at-file-level" aria-label="Permalink to &quot;Step 4.1: Test Gaps at File Level&quot;">​</a></h3><p>In Teamscale, go to <em>Test Gaps &gt; Files</em> and set the baseline to Git Tag <code>v2.5</code> at the top.</p><div class="tip custom-block"><p class="custom-block-title">Test Gaps Between Two Dates</p><p>If you need to see the test gaps between two specific dates:</p><ul><li>first you have to select the start date as a baseline at the top of the view,</li><li>then click on &quot;Latest Test Gaps&quot; to activate the time travel mode, and select the end date.</li></ul><p>After closing the time travel dialog, the view will display the test gaps between the two selected dates.</p></div><p>The table on the page shows the file-system structure of the Blogifier project, with <em>Test Gaps</em>, <em>Execution</em>, and <em>Churn</em> data aggregated for each file or directory. You may drill down into the folders and click on the colored bar charts to check what exactly has been changed or executed and where the test gaps are.</p><p><img src="'+p+'" alt="Test Gaps, Coverage, and Churn at File-System Level" width="1234" height="588" data-zoom="true"></p><div class="warning custom-block"><p class="custom-block-title">Hint</p><p>The Execution and Test Gap data may look different for you, depending on the actions you performed in Blogifier.</p></div><h3 id="step-4-2-test-gaps-at-method-level" tabindex="-1">Step 4.2: Test Gaps at Method Level <a class="header-anchor" href="#step-4-2-test-gaps-at-method-level" aria-label="Permalink to &quot;Step 4.2: Test Gaps at Method Level&quot;">​</a></h3><p>In Teamscale, go to <em>Dashboards</em>. In the top bar click <em>Add a new dashboard</em> and then choose <em>Test Gap Treemap</em> from the list of widgets. Finally, click <em>Save Dashboard</em> and name the Dashboard <code>Blogifier Test Gaps</code>.</p><p>Move the mouse over the Test Gap Treemap and click on the <i class="cog icon"></i> icon that appears in the upper left, to edit the widget. As the <em>Baseline</em>, select the Git tag <code>v2.5</code>. Make sure that <em>Manual Tests</em> is selected under <em>Coverage Sources</em>, for the widget to consider the coverage you uploaded earlier. Confirm the dialog.</p><p><img src="'+h+'" alt="Configuring a Test-Gap Treemap on a Teamscale Dashboard" width="559" height="654"></p><p>The widget now shows the code changes between version 2.5 and 3.0 in color. The red and yellow blocks represent methods that have been changed, but were not covered by tests, i.e., test gaps. Hover the mouse over the blocks in the treemap to see details in a tooltip. Click on the blocks to drill into the data.</p><p><img src="'+c+'" alt="Test Gaps on the Code Changes between Version 2.5 and 3.0 of Blogifier" width="1234" height="587" data-zoom="true"></p><div class="warning custom-block"><p class="custom-block-title">Hint</p><p>The treemap may look different for you, depending on the actions you performed in Blogifier.</p></div><hr><h4 id="further-reading" tabindex="-1">Further Reading: <a class="header-anchor" href="#further-reading" aria-label="Permalink to &quot;Further Reading:&quot;">​</a></h4><ol><li><a href="./../../reference/test-gap-analysis/">Test Gap Analysis</a></li><li><a href="./../../reference/ui/testgaps/">Test Gaps Perspective</a></li><li><a href="./../../howto/creating-a-tga-dashboard/">How to Create a Test Gap Analysis Dashboard</a></li><li><a href="./../../tutorial/working-with-test-gap-treemaps/">Working with Test Gap Treemaps</a></li></ol>',74)])])}const b=s(d,[["render",g]]);export{v as __pageData,b as default};
