# Description
Prefer IS NOT to NOT IS

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-is-not-to-not-is

"if not is_valid( )." examples are skipped

# Examples
**Bad example**
```abap
IF NOT variable IS INITIAL.
IF NOT variable CP 'TODO*'.
IF NOT variable = 42.
IF NOT variable CA 'hello'.
```

**Good example**
```abap
IF variable IS NOT INITIAL.
IF variable NP 'TODO*'.
IF variable <> 42.
IF variable CO 'hello'.
```

# Clean ABAP Code Style Guide
```ABAP
IF variable IS NOT INITIAL.
IF variable NP 'TODO*'.
IF variable <> 42.
```

Negation is logically equivalent
but requires a "mental turnaround"
that makes it harder to understand.

```ABAP
" anti-pattern
IF NOT variable IS INITIAL.
IF NOT variable CP 'TODO*'.
IF NOT variable = 42.
```

> A more specific variant of
[Try to make conditions positive](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#try-to-make-conditions-positive).
Also as described in the section
[Alternative Language Constructs](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenalternative_langu_guidl.htm)
in the ABAP programming guidelines.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefer_is_not) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
