Safely creating a temporary file or directory means following a number of rules
(see the references for more details). This plugin test looks for strings
starting with (configurable) commonly used temporary paths, for example:

- /tmp
- /var/tmp
- /dev/shm
- etc

**Config Options:**

This test plugin takes a similarly named config block,
`hardcoded_tmp_directory`. The config block provides a Python list, `tmp_dirs`,
that lists string fragments indicating possible temporary file paths. Any
string starting with one of these fragments will report a MEDIUM confidence
issue.

``` python

hardcoded_tmp_directory:
tmp_dirs: ['/tmp', '/var/tmp', '/dev/shm']


```
## Example

.. code-block: none

In the following code snippet the issue is: Probable insecure usage of temp file/directory.
For more information on this see: CWE-377 (https://cwe.mitre.org/data/definitions/377.html)
``` python
f = open('/tmp/abc', 'w')
f.write('def')
## see also:
- https://security.openstack.org/guidelines/dg_using-temporary-files-securely.html
- https://cwe.mitre.org/data/definitions/377.html
New in version  0.9.0
Changed in version  1.7.3
CWE information added
