This test is for checking for the usage of insecure SNMP cryptography:
v3 using noAuthNoPriv.

Please update your code to use more secure versions of SNMP. For example:

Instead of:
`CommunityData('public', mpModel=0)`

Use (Defaults to usmHMACMD5AuthProtocol and usmDESPrivProtocol
`UsmUserData("securityName", "authName", "privName")`

## Example


In the following code snippet the issue is: [B509:snmp_crypto_check] You should not use SNMPv3 without encryption. noAuthNoPriv & authNoPriv is insecure
More Info: https://bandit.readthedocs.io/en/latest/plugins/b509_snmp_crypto_check.html
``` python
  # SHOULD FAIL
  insecure = UsmUserData("securityName")
  # SHOULD FAIL
```
## see also:

- http://snmplabs.com/pysnmp/examples/hlapi/asyncore/sync/manager/cmdgen/snmp-versions.html
- https://cwe.mitre.org/data/definitions/319.html

New in version  1.7.2

Changed in version  1.7.3
CWE information added
