
Use `var`, not `final`, when declaring local variables.

Per [Effective Dart](https://dart.dev/effective-dart/usage#do-follow-a-consistent-rule-for-var-and-final-on-local-variables),
there are two styles in wide use. This rule enforces the `var` style.
For the alternative style that prefers `final`, enable `prefer_final_locals`
and `prefer_final_in_for_each` instead.

For fields, `final` is always recommended; see the rule `prefer_final_fields`.

**BAD:**
```dart
void badMethod() {
  final label = 'Final or var?';
  for (final char in ['v', 'a', 'r']) {
    print(char);
  }
}
```

**GOOD:**
```dart
void goodMethod() {
  var label = 'Final or var?';
  for (var char in ['v', 'a', 'r']) {
    print(char);
  }
}
```