Disallows the declaration of impure pipes

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  pure: false
  ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test',
  'pure': false,
  ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test',
  ['pure']: !true
  ~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test',
  [`pure`]: false
  ~~~~~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe()
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Pipe(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test',
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  pure: true
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  'pure': !0,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  ['pure']: !!isPure(),
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const pure = 'pure';
@Pipe({
  [pure]: false
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const pure = false;
@Pipe({
  pure,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
function isPure() {
  return false;
}

@Pipe({
  [`pure`]: isPure(),
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [Foo]
})
class Test {}
```

</details>
