Ensures that the two-way data binding syntax is correct

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<input type="text" name="foo" ([ngModel])="foo">
                              ~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<app-item ([bar])="bar" ([item])="item" [(test)]="test"></app-item>
          ~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~
<div [baz]="oneWay" (emitter)="emitter" ([twoWay])="twoWay"></div>
                                        ~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<input type="text" name="foo" [ngModel]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text" name="foo" [(ngModel)]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="button" (click)="navigate(['/resources'])">
  Navigate
</button>
```

</details>
