Enforce closing bracket location in JSX.




Enforce the closing bracket location for JSX multiline elements.

## Rule Details

This rule checks all JSX multiline elements and verifies the location of the closing bracket. By default this one must be aligned with the opening tag.

Examples of **incorrect** code for this rule:

```jsx
<Hello
  lastName="Smith"
  firstName="John" />;

<Hello
  lastName="Smith"
  firstName="John"
  />;
```

Examples of **correct** code for this rule:

```jsx
<Hello firstName="John" lastName="Smith" />;

<Hello
  firstName="John"
  lastName="Smith"
/>;
```

## When Not To Use It

If you are not using JSX then you can disable this rule.
