<h2>Why is this an issue?</h2>
<p>When exceptions occur, it is usually a bad idea to simply ignore them. Instead, it is better to handle them properly, or at least to log them.</p>
<p>This rule only reports on empty catch clauses that catch generic <code>Exception</code>s.</p>
<h3>Noncompliant code example</h3>
<pre>
string text = "";
try
{
    text = File.ReadAllText(fileName);
}
catch (Exception exc) // Noncompliant
{
}
</pre>
<h3>Compliant solution</h3>
<pre>
string text = "";
try
{
    text = File.ReadAllText(fileName);
}
catch (Exception exc)
{
    logger.Log(exc);
}
</pre>
<h3>Exceptions</h3>
<p>When a block contains a comment, it is not considered to be empty.</p>
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A09_2021-Security_Logging_and_Monitoring_Failures/">Top 10 2021 Category A9 - Security Logging and
  Monitoring Failures</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A10_2017-Insufficient_Logging%2526Monitoring">Top 10 2017 Category A10 -
  Insufficient Logging &amp; Monitoring</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/390">CWE-390 - Detection of Error Condition Without Action</a> </li>
</ul>

