<h2>Why is this an issue?</h2>
<p>Adherence to the standard naming conventions makes your code not only more readable, but more usable. For instance, <code>class FirstAttribute :
Attribute</code> can be used simply with <code>First</code>, but you must use the full name for <code>class AttributeOne : Attribute</code>.</p>
<p>This rule raises an issue when classes extending <code>Attribute</code>, <code>EventArgs</code>, or <code>Exception</code>, do not end with their
parent class names.</p>
<h3>Noncompliant code example</h3>
<pre>
class AttributeOne : Attribute  // Noncompliant
{
}
</pre>
<h3>Compliant solution</h3>
<pre>
class FirstAttribute : Attribute
{
}
</pre>
<h3>Exceptions</h3>
<p>If a class' direct base class doesn’t follow the convention, then no issue is reported on the class itself, regardless of whether or not it
conforms to the convention.</p>
<pre>
class Timeout : Exception // Noncompliant
{
}
class ExtendedTimeout : Timeout // Ignored; doesn't conform to convention, but the direct base doesn't conform either
{
}
</pre>

