<h2>Why is this an issue?</h2>
<p><a href="https://learn.microsoft.com/en-us/dotnet/api/system.nullable-1">Nullable value types</a> can hold either a value or <code>null</code>.</p>
<p>The value held in the nullable type can be accessed with the <code>Value</code> property or by casting it to the underlying type. Still, both
operations throw an <code>InvalidOperationException</code> when the value is <code>null</code>. A nullable type should always be tested before
accessing the value to avoid raising exceptions.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
void Sample(bool condition)
{
    int? nullableValue = condition ? 42 : null;
    Console.WriteLine(nullableValue.Value); // Noncompliant: InvalidOperationException is raised

    int? nullableCast = condition ? 42 : null;
    Console.WriteLine((int)nullableCast);   // Noncompliant: InvalidOperationException is raised
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
void Sample(bool condition)
{
    int? nullableValue = condition ? 42 : null;
    if (nullableValue.HasValue)
    {
      Console.WriteLine(nullableValue.Value);
    }

    int? nullableCast = condition ? 42 : null;
    if (nullableCast is not null)
    {
      Console.WriteLine((int)nullableCast);
    }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.nullable-1">Nullable&lt;T&gt;</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 - NULL Pointer Dereference</a> </li>
</ul>

