## SA1139

<table>
<tr>
  <td>TypeName</td>
  <td>SA1139UseLiteralsSuffixNotationInsteadOfCasting</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1139</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A cast is performed instead of using literal of a number. 

## Rule description

A cast is performed instead of using literal of a number. Use "U" suffix to create 32-bit unsigned integer, "L" for 64-bit integer, "UL" for 64-bit unsigned integer, "F" for 32-bit floating point number, "D" for 64-bit floating point number, and "M" for a decimal number. Suffixes are case-insensitive.

For example, the following code would produce a violation of this rule:

```csharp
var x = (long)1;
```

The following code would not produce any violations:

```csharp
var x = 1L;
```

## How to fix violations

To fix a violation of this rule, use the appropriate literal suffix instead of casting the value in code.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1139:UseLiteralsSuffixNotationInsteadOfCasting", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1139 // Use literal suffix notation instead of casting
#pragma warning restore SA1139 // Use literal suffix notation instead of casting
```
