## SA1313

<table>
<tr>
  <td>TypeName</td>
  <td>SA1313ParameterNamesMustBeginWithLowerCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1313</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The name of a parameter in C# does not begin with a lower-case letter.

## Rule description

A violation of this rule occurs when the name of a parameter does not begin with a lower-case letter.

An exception to this rule is made for lambda parameters named `_` and `__`. These parameters are often used to designate a
placeholder parameter which is not actually used in the body of the lambda expression.

If the parameter name is intended to match the name of an item associated with Win32 or COM, and thus needs to begin
with an upper-case letter, place the parameter within a special `NativeMethods` class. A `NativeMethods` class is any
class which contains a name ending in `NativeMethods`, and is intended as a placeholder for Win32 or COM wrappers.
StyleCop will ignore this violation if the item is placed within a `NativeMethods` class.

## How to fix violations

To fix a violation of this rule, change the name of the parameter so that it begins with a lower-case letter, or place
the item within a `NativeMethods` class if appropriate.

## How to suppress violations

```csharp
#pragma warning disable SA1313 // ParameterNamesMustBeginWithLowerCaseLetter
void Method(int Parameter)
#pragma warning restore SA1313 // ParameterNamesMustBeginWithLowerCaseLetter
{
}
```
