﻿## SA1409

<table>
<tr>
  <td>TypeName</td>
  <td>SA1409RemoveUnnecessaryCode</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1409</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A C# file contains code which is unnecessary and can be removed without changing the overall logic of the code.

## Rule description

A violation of this rule occurs when the file contains code which can be removed without changing the overall logic of the code.

For example, the following try-catch statement could be removed completely since the try and catch blocks are both empty.

```csharp
try
{
}
catch (Exception ex)
{
}
```

The try-finally statement below does contain code within the try block, but it does not contain any catch blocks, and the finally block is empty. Thus, the try-finally is not performing any useful function and can be removed.

```csharp
try
{
    this.Method();
}
finally
{
}
```

As a final example, the unsafe statement below is empty, and thus provides no value.

```csharp
unsafe
{
}
```

## How to fix violations

The fix a violation of this rule, remove the unnecessary code, or fill in the code with additional statements.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1409:RemoveUnnecessaryCode", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1409 // RemoveUnnecessaryCode
#pragma warning restore SA1409 // RemoveUnnecessaryCode
```
