﻿## SA1616

<table>
<tr>
  <td>TypeName</td>
  <td>SA1616ElementReturnValueDocumentationMustHaveText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1616</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The `<returns>` tag within a C# element's documentation header is empty.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if an element contains an empty `<returns>` tag.

## How to fix violations

To fix a violation of this rule, fill-in documentation text within the `<returns>` tag describing the value returned from the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1616:ElementReturnValueDocumentationMustHaveText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1616 // ElementReturnValueDocumentationMustHaveText
#pragma warning restore SA1616 // ElementReturnValueDocumentationMustHaveText
```
