﻿## SA1622

<table>
<tr>
  <td>TypeName</td>
  <td>SA1622GenericTypeParameterDocumentationMustHaveText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1622</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A `<typeparam>` tag within the Xml header documentation for a generic C# element is empty.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if the element contains an empty `<typeparam>` tag within its Xml header documentation.

## How to fix violations

To fix a violation of this rule, fill-in each `<typeparam>` tag within a description of the generic type parameter.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// A sample generic class.
/// </summary>
/// <typeparam name="S">The first generic type parameter.</typeparam>
/// <typeparam name="T">The second generic type parameter.</typeparam>
public class Class1<S, T>
{ 
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1622:GenericTypeParameterDocumentationMustHaveText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1622 // GenericTypeParameterDocumentationMustHaveText
#pragma warning restore SA1622 // GenericTypeParameterDocumentationMustHaveText
```
