﻿## SA1637

<table>
<tr>
  <td>TypeName</td>
  <td>SA1637FileHeaderMustContainFileName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1637</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file is missing the file name.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain a valid file name tag. For example:

```csharp
//-----------------------------------------------------------------------
// <copyright company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

A file header should include a file tag containing the name of the file, as follows:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add a file tag containing the name of the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1637:FileHeaderMustContainFileName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1637 // FileHeaderMustContainFileName
#pragma warning restore SA1637 // FileHeaderMustContainFileName
```
