<h2>Why is this an issue?</h2>
<p>Empty statements represented by a semicolon <code>;</code> are statements that do not perform any operation. They are often the result of a typo or
a misunderstanding of the language syntax. It is a good practice to remove empty statements since they don’t add value and lead to confusion and
errors.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
void doSomething() {
  ; // Noncompliant - was used as a kind of TODO marker
}

void doSomethingElse() {
  System.out.println("Hello, world!");; // Noncompliant - double ;
  // ...
}
```
<h4>Compliant solution</h4>

```java
void doSomething() {}

void doSomethingElse() {
  System.out.println("Hello, world!");
  // ...
  for (int i = 0; i < 3; i++) ; // Compliant if unique statement of a loop
  // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/5dUxBQ">CERT, MSC12-C.</a> - Detect and remove code that has no effect or is never executed
  </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/IDZGBQ">CERT, MSC51-J.</a> - Do not place a semicolon immediately following an if, for, or while
  condition </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/WtYxBQ">CERT, EXP15-C.</a> - Do not place a semicolon on the same line as an if, for, or while
  statement </li>
</ul>