<h2>Why is this an issue?</h2>
<p><code>Throwable</code> is the superclass of all errors and exceptions in Java. <code>Error</code> is the superclass of all errors, which are not
meant to be caught by applications.</p>
<p>Catching either <code>Throwable</code> or <code>Error</code> will also catch <code>OutOfMemoryError</code> and <code>InternalError</code>, from
which an application should not attempt to recover.</p>
<h3>Noncompliant code example</h3>

```java
try { /* ... */ } catch (Throwable t) { /* ... */ }
try { /* ... */ } catch (Error e) { /* ... */ }
```
<h3>Compliant solution</h3>

```java
try { /* ... */ } catch (RuntimeException e) { /* ... */ }
try { /* ... */ } catch (MyException e) { /* ... */ }
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/396">CWE-396 - Declaration of Catch for Generic Exception</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/display/java/ERR08-J.+Do+not+catch+NullPointerException+or+any+of+its+ancestors">CERT,
  ERR08-J.</a> - Do not catch NullPointerException or any of its ancestors </li>
</ul>