<p>This rule raises an issue when the <code>Collections.EMPTY_*</code> fields are used instead of the <code>Collections.empty*()</code> methods.</p>
<h2>Why is this an issue?</h2>
<p>Generic types (types with type parameters) have been introduced into Java with language version 1.5. If type parameters are specified for a class
or method, it is still possible to ignore them to keep backward compatibility with older code, which is called the <em>raw type</em> of the class or
interface.</p>
<p>Using raw type expressions is highly discouraged because the compiler cannot perform static type checking on them. This means that the compiler
will not report typing errors about them at compile time, but a <code>ClassCastException</code> will be thrown during runtime.</p>
<p>In Java 1.5, generics were also added to the Java collections API, and the data structures in <code>java.util</code>, such as <code>List</code>,
<code>Set</code>, or <code>Map</code>, now feature type parameters. <code>Collections.EMPTY_LIST</code>, <code>Collections.EMPTY_SET</code>, and
<code>Collections.EMPTY_MAP</code> are relics from before generics, and they return raw lists, sets, or maps, with the limitations mentioned
above.</p>
<h2>How to fix it</h2>
<p>Use:</p>
<ul>
  <li> <code>Collections.emptyList()</code> instead of <code>Collections.EMPTY_LIST</code> </li>
  <li> <code>Collections.emptySet()</code> instead of <code>Collections.EMPTY_SET</code> </li>
  <li> <code>Collections.emptyMap()</code> instead of <code>Collections.EMPTY_MAP</code> </li>
</ul>
<p>In addition, there are variants of <code>Collections.empty*()</code> available also for other collection interfaces, such as
<code>Collections.emptyIterator()</code>, <code>Collections.emptyNavigableMap()</code>, <code>Collections.emptySortedSet()</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
List<String> collection1 = Collections.EMPTY_LIST;     // Noncompliant, raw List
Set<Float> collection2 = Collections.EMPTY_SET;        // Noncompliant, raw Set
Map<Int, String> collection3 = Collections.EMPTY_MAP;  // Noncompliant, raw Map
```
<h4>Compliant solution</h4>

```java
List<String> collection1 = Collections.emptyList();    // Compliant, List<String>
Set<Float> collection2 = Collections.emptySet();       // Compliant, Set<Float>
Map<Int, String> collection3 = Collections.emptyMap(); // Compliant, Map<Int, String>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/util/Collections.html">Oracle - Java™ Platform, Standard Edition 8 API Specification,
  Class Collections</a> </li>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/generics/rawTypes.html">Oracle - The Java™ Tutorials - Raw Types</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://www.baeldung.com/java-generics">Baeldung - The Basics of Java Generics</a> </li>
</ul>