<h2>Why is this an issue?</h2>
<p>Calling <code>toString()</code> or <code>clone()</code> on an object should always return a string or an object. Returning <code>null</code>
instead contravenes the method’s implicit contract.</p>
<h3>Noncompliant code example</h3>

```java
public String toString () {
  if (this.collection.isEmpty()) {
    return null; // Noncompliant
  } else {
    // ...
```
<h3>Compliant solution</h3>

```java
public String toString () {
  if (this.collection.isEmpty()) {
    return "";
  } else {
    // ...
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 - NULL Pointer Dereference</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/aDdGBQ">CERT, EXP01-J.</a> - Do not use a null in a case where an object is required </li>
</ul>