<h2>Why is this an issue?</h2>
<p><code>java.util.concurrent.locks.Lock</code> offers far more powerful and flexible locking operations than are available with
<code>synchronized</code> blocks. So synchronizing on a <code>Lock</code> instance throws away the power of the object, as it overrides its better
locking mechanisms. Instead, such objects should be locked and unlocked using one of their <code>lock</code> and <code>unlock</code> method
variants.</p>
<h3>Noncompliant code example</h3>

```java
Lock lock = new MyLockImpl();
synchronized(lock) {  // Noncompliant
  // ...
}
```
<h3>Compliant solution</h3>

```java
Lock lock = new MyLockImpl();
if (lock.tryLock()) {
  try {
    // ...
  } finally {
    lock.unlock();
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/qjdGBQ">CERT, LCK03-J.</a> - Do not synchronize on the intrinsic locks of high-level concurrency
  objects </li>
</ul>