<h2>Why is this an issue?</h2>
<p>Altering or bypassing the accessibility of classes, methods, or fields through reflection violates the encapsulation principle. This can break the
internal contracts of the accessed target and lead to maintainability issues and runtime errors.</p>
<p>This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a
field value.</p>

```java
public void makeItPublic(String methodName) throws NoSuchMethodException {

  this.getClass().getMethod(methodName).setAccessible(true); // Noncompliant
}

public void setItAnyway(String fieldName, int value) {
  this.getClass().getDeclaredField(fieldName).setInt(this, value); // Noncompliant; bypasses controls in setter
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://en.wikipedia.org/wiki/Encapsulation_(computer_programming)">Wikipedia definition of Encapsulation</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/_jZGBQ">CERT, SEC05-J.</a> - Do not use reflection to increase accessibility of classes,
  methods, or fields </li>
</ul>