<h2>Why is this an issue?</h2>
<p>The compiler automatically initializes class fields to their default values before setting them with any initialization values, so there is no need
to explicitly set a field to its default value. Further, under the logic that cleaner code is better code, it’s considered poor style to do so.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {

  int count = 0;  // Noncompliant
  // ...

}
```
<h3>Compliant solution</h3>

```java
public class MyClass {

  int count;
  // ...

}
```
<h3>Exceptions</h3>
<p><code>final</code> fields are ignored.</p>