<h2>Why is this an issue?</h2>
<p>The Java language authors have been quite frank that <code>Optional</code> was intended for use only as a return type, as a way to convey that a
method may or may not return a value.</p>
<p>And for that, it’s valuable but using <code>Optional</code> on the input side increases the work you have to do in the method without really
increasing the value. With an <code>Optional</code> parameter, you go from having 2 possible inputs: null and not-null, to three: null,
non-null-without-value, and non-null-with-value. Add to that the fact that overloading has long been available to convey that some parameters are
optional, and there’s really no reason to have <code>Optional</code> parameters.</p>
<p>The rule also checks for Guava’s <code>Optional</code>, as it was the inspiration for the JDK <code>Optional</code>. Although it is different in
some aspects (serialization, being recommended for use as collection elements), using it as a parameter type causes exactly the same problems as for
JDK <code>Optional</code>.</p>
<h3>Noncompliant code example</h3>

```java
public String sayHello(Optional<String> name) {  // Noncompliant
  if (name == null || !name.isPresent()) {
    return "Hello World";
  } else {
    return "Hello " + name;
  }
}
```
<h3>Compliant solution</h3>

```java
public String sayHello(String name) {
  if (name == null) {
    return "Hello World";
  } else {
    return "Hello " + name;
  }
}
```
<h3>Exceptions</h3>
<p>No issues will be raised if a method is overriding, as the developer has no control over the signature at this point.</p>

```java
@Override
public String sayHello(Optional<String> name) {
  if (name == null || !name.isPresent()) {
    return "Hello World";
  } else {
    return "Hello " + name;
  }
}
```