<h2>Why is this an issue?</h2>
<p>Jump statements such as <code>return</code> and <code>continue</code> let you change the default flow of program execution, but jump statements
that direct the control flow to the original direction are just a waste of keystrokes.</p>
<h3>Noncompliant code example</h3>

```java
public void foo() {
  while (condition1) {
    if (condition2) {
      continue; // Noncompliant
    } else {
      doTheThing();
    }
  }
  return; // Noncompliant; this is a void method
}
```
<h3>Compliant solution</h3>

```java
public void foo() {
  while (condition1) {
    if (!condition2) {
      doTheThing();
    }
  }
}
```