<h2>Why is this an issue?</h2>
<p>When <code>java.io.File#delete</code> fails, this <code>boolean</code> method simply returns <code>false</code> with no indication of the cause. On
the other hand, when <code>java.nio.file.Files#delete</code> fails, this <code>void</code> method returns one of a series of exception types to better
indicate the cause of the failure. And since more information is generally better in a debugging situation, <code>java.nio.file.Files#delete</code> is
the preferred option.</p>
<h3>Noncompliant code example</h3>

```java
public void cleanUp(Path path) {
  File file = new File(path);
  if (!file.delete()) {  // Noncompliant
    //...
  }
}
```
<h3>Compliant solution</h3>

```java
public void cleanUp(Path path) throws NoSuchFileException, DirectoryNotEmptyException, IOException {
  Files.delete(path);
}
```