<h2>Why is this an issue?</h2>
<p>Looking for a given substring starting from a specified offset can be achieved by such code: <code>str.substring(beginIndex).indexOf(char1)</code>.
This works well, but it creates a new <code>String</code> for each call to the <code>substring</code> method. When this is done in a loop, a lot of
<code>Strings</code> are created for nothing, which can lead to performance problems if <code>str</code> is large.</p>
<p>To avoid performance problems, <code>String.substring(beginIndex)</code> should not be chained with the following methods:</p>
<ul>
  <li> <code>indexOf(int ch)</code> </li>
  <li> <code>indexOf(String str)</code> </li>
  <li> <code>lastIndexOf(int ch)</code> </li>
  <li> <code>lastIndexOf(String str)</code> </li>
  <li> <code>startsWith(String prefix)</code> </li>
</ul>
<p>For each of these methods, another method with an additional parameter is available to specify an offset.</p>
<p>Using these methods will avoid the creation of additional <code>String</code> instances. For indexOf methods, adjust the returned value by
subtracting the substring index parameter to obtain the same result.</p>
<h3>Noncompliant code example</h3>

```java
str.substring(beginIndex).indexOf(char1); // Noncompliant; a new String is going to be created by "substring"
```
<h3>Compliant solution</h3>

```java
str.indexOf(char1, beginIndex) - beginIndex; // index for char1 not found is (-1-beginIndex)
```