<h2>Why is this an issue?</h2>
<p>Most checks against an <code>indexOf</code> value compare it with -1 because 0 is a valid index. Checking against <code>&gt; 0</code> ignores the
first element, which is likely a bug.</p>

```js
let arr = ["blue", "red"];

if (arr.indexOf("blue") > 0) { // Noncompliant
  // ...
}
```
<p>Moreover, if the intent is merely to check the presence of the element, and if your browser version supports it, consider using
<code>includes</code> instead.</p>

```js
let arr = ["blue", "red"];

if (arr.includes("blue")) {
  // ...
}
```
<p>This rule raises an issue when an <code>indexOf</code> value retrieved from an array is tested against <code>&gt; 0</code>.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes"><code>Array.prototype.includes()</code></a>
  </li>
</ul>